package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import org.jeecg.common.aspect.annotation.Dict;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.UnsupportedEncodingException;

/**
 * @Description: 鑫宏配送单明细
 * @Author: jeecg-boot
 * @Date:   2024-11-29
 * @Version: V1.0
 */
@Data
@TableName("xh_out_order_delivery_item")
@ApiModel(value="xh_out_order_delivery_item对象", description="鑫宏配送单明细")
public class XhOutOrderDeliveryItem implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
	/**配送单号*/
    @Excel(name = "配送单号", width = 15)
    @ApiModelProperty(value = "配送单号")
    private String orderNo;
	/**订单明细行*/
	@Excel(name = "配送单明细行", width = 15)
    @ApiModelProperty(value = "订单明细行号")
    private Integer orderLine;
	/**物料号*/
	@Excel(name = "物料号", width = 15)
    @ApiModelProperty(value = "物料号")
    private String goodsCode;
	/**物料名称*/
	//@Excel(name = "物料名称", width = 15)
    @ApiModelProperty(value = "物料名称")
    private String goodsName;
	/**批次，目前未使用*/
	//@Excel(name = "批次", width = 15)
    @ApiModelProperty(value = "批次")
    private String batchNo;
	/**需求数量*/
	@Excel(name = "需求数量", width = 15)
    @ApiModelProperty(value = "需求数量")
    private java.math.BigDecimal qty;
	/**实际配送数量*/
	//@Excel(name = "实际配送数量", width = 15)
    @ApiModelProperty(value = "实际配送数量")
    private java.math.BigDecimal realQty;
	/**状态*/
	//@Excel(name = "状态", width = 15)
    @ApiModelProperty(value = "状态")
	@Dict(dicCode = "xh_out_order_delivery_item_status")
	private String itemStatus;
	/**配送时间*/
	//@Excel(name = "配送时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "配送时间")
    private Date deliveryTime;
	/**创建账号*/
    @ApiModelProperty(value = "创建账号")
    private String createBy;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**修改账号*/
    @ApiModelProperty(value = "修改账号")
    private String updateBy;
	/**修改时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
}
