package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 料箱出库信息
 * @Author: jeecg-boot
 * @Date: 2024-08-28
 * @Version: V1.0
 */
@Data
@TableName("xh_out_order_box")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "xh_out_order_box对象", description = "料箱出库信息")
public class XhOutOrderBox implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
    /**
     * 出库单ID
     */
    @Excel(name = "出库单ID", width = 15)
    @ApiModelProperty(value = "出库单ID")
    private Integer orderId;
    /**
     * 料箱号
     */
    @Excel(name = "料箱号", width = 15)
    @ApiModelProperty(value = "料箱号")
    private String boxCode;
    /**
     * 料箱号
     */
    @Excel(name = "实际料箱号", width = 15)
    @ApiModelProperty(value = "实际料箱号")
    private String realBoxCode;
    /**
     * 托盘号
     */
    @Excel(name = "托盘号", width = 15)
    @ApiModelProperty(value = "托盘号")
    private String palletCode;
    /**
     * 仓库
     */
    @Excel(name = "仓库", width = 15)
    @ApiModelProperty(value = "仓库")
    @Dict(dicCode = "ware_code")
    private String wareCode;
    /**
     * 工站号
     */
    @Excel(name = "工站号", width = 15)
    @ApiModelProperty(value = "工站号")
    private String stationCode;
    /**
     * 状态
     */
    @Excel(name = "状态", width = 15)
    @ApiModelProperty(value = "状态")
    @Dict(dicCode = "wms_out_order_status")
    private String status;
    /**
     * 到站时间
     */
    @Excel(name = "到站时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "到站时间")
    private Date startTime;
    /**
     * 完成时间
     */
    @Excel(name = "完成时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "完成时间")
    private Date finishTime;
    /**
     * 创建账号
     */
    @ApiModelProperty(value = "创建账号")
    private String createBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 修改账号
     */
    @ApiModelProperty(value = "修改账号")
    private String updateBy;
    /**
     * 修改时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
}
