package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 任务子项
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@Data
@TableName("wms_task_item")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="wms_task_item对象", description="任务子项")
public class WmsTaskItem implements Serializable {
    private static final long serialVersionUID = 1L;

	/**id*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
    private Integer id;
	/**任务号*/
	@Excel(name = "任务号", width = 15)
    @ApiModelProperty(value = "任务号")
    private Integer taskId;
	/**单据子项id*/
	@Excel(name = "单据子项id", width = 15)
    @ApiModelProperty(value = "单据子项id")
    private Integer orderItemId;
	/**类型*/
	@Excel(name = "类型", width = 15,dicCode = "wms_task_item_type")
    @ApiModelProperty(value = "类型")
    @Dict(dicCode = "wms_task_item_type")
    private String type;
	/**状态*/
	@Excel(name = "状态", width = 15,dicCode = "wms_task_status")
    @ApiModelProperty(value = "状态")
    @Dict(dicCode = "wms_task_status")
    private String itemStatus;
	/**是否是远程任务*/
	@Excel(name = "是否是远程任务", width = 15)
    @ApiModelProperty(value = "是否是远程任务")
    private Integer isRemote;
	/**起始库位*/
	@Excel(name = "起始库位", width = 15)
    @ApiModelProperty(value = "起始库位")
    private String fromLocCode;
	/**结束库位*/
	@Excel(name = "结束库位", width = 15)
    @ApiModelProperty(value = "结束库位")
    private String toLocCode;
	/**搬运类型*/
	@Excel(name = "搬运类型", width = 15,dicCode = "wms_transport_type")
    @ApiModelProperty(value = "搬运类型")
    @Dict(dicCode = "wms_transport_type")
    private String transportType;
	/**货箱编码*/
	@Excel(name = "货箱编码", width = 15)
    @ApiModelProperty(value = "货箱编码")
    private String qrCode;
	/**货品sku*/
	@Excel(name = "货品sku", width = 15)
    @ApiModelProperty(value = "货品sku")
    private String sku;
	/**批次号*/
	@Excel(name = "批次号", width = 15)
    @ApiModelProperty(value = "批次号")
    private String batchNo;
	/**数量*/
	@Excel(name = "数量", width = 15)
    @ApiModelProperty(value = "数量")
    private BigDecimal qty;
    /**物料名*/
    @Excel(name = "物料名", width = 15)
    @ApiModelProperty(value = "物料名")
    private String name;
	/**执行组*/
	@Excel(name = "执行组", width = 15)
    @ApiModelProperty(value = "执行组")
    private String execGroup;
	/**执行顺序*/
	@Excel(name = "执行顺序", width = 15)
    @ApiModelProperty(value = "执行顺序")
    private Integer execIndex;
	/**是否延迟执行*/
	@Excel(name = "是否延迟执行", width = 15)
    @ApiModelProperty(value = "是否延迟执行")
    private Integer lazyExecute;
	/**优先级*/
	@Excel(name = "优先级", width = 15)
    @ApiModelProperty(value = "优先级")
    private Integer priority;
	/**依赖于*/
	@Excel(name = "依赖于", width = 15)
    @ApiModelProperty(value = "依赖于")
    private Integer dependOn;
	/**执行时间*/
	@Excel(name = "执行时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "执行时间")
    private Date executeTime;
	/**完成时间*/
	@Excel(name = "完成时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "完成时间")
    private Date finishTime;
	/**执行结果*/
	@Excel(name = "执行结果", width = 15)
    @ApiModelProperty(value = "执行结果")
    private String result;
	/**错误信息*/
	@Excel(name = "错误信息", width = 15)
    @ApiModelProperty(value = "错误信息")
    private String errorMsg;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
