package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 库位货品库存
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@Data
@TableName("wms_stock_loc_sku")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="wms_stock_loc_sku对象", description="库位货品库存")
public class WmsStockLocSku implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
	/**仓库编码*/
	@Excel(name = "仓库编码", width = 15)
    @ApiModelProperty(value = "仓库编码")
    private String wareCode;
	/**料箱编号*/
	@Excel(name = "料箱编号", width = 15)
    @ApiModelProperty(value = "料箱编号")
    private String containerCode;
	/**sku*/
	@Excel(name = "sku", width = 15)
    @ApiModelProperty(value = "sku")
    private String sku;
	/**批次号*/
	@Excel(name = "批次号", width = 15)
    @ApiModelProperty(value = "批次号")
    private String batchNo;
	/**品番类型*/
	@Excel(name = "品番类型", width = 15)
    @ApiModelProperty(value = "品番类型")
    private String type;
	/**库位号*/
	@Excel(name = "库位号", width = 15)
    @ApiModelProperty(value = "库位号")
    private String locCode;
	/**楼层*/
	@Excel(name = "楼层", width = 15)
    @ApiModelProperty(value = "楼层")
    private Integer layer;
	/**虚拟库区*/
	@Excel(name = "虚拟库区", width = 15)
    @ApiModelProperty(value = "虚拟库区")
    private String areaCode;
	/**实际库区*/
	@Excel(name = "实际库区", width = 15)
    @ApiModelProperty(value = "实际库区")
    private String actualArea;
	/**库存数量*/
	@Excel(name = "库存数量", width = 15)
    @ApiModelProperty(value = "库存数量")
    private BigDecimal qty;
	/**分配数量*/
	@Excel(name = "分配数量", width = 15)
    @ApiModelProperty(value = "分配数量")
    private BigDecimal qtyAllocated;
	/**上架数量*/
	@Excel(name = "上架数量", width = 15)
    @ApiModelProperty(value = "上架数量")
    private BigDecimal qtyPutaway;
	/**冻结数量*/
	@Excel(name = "冻结数量", width = 15)
    @ApiModelProperty(value = "冻结数量")
    private BigDecimal qtyHold;
	/**预留字段1*/
	@Excel(name = "预留字段1", width = 15)
    @ApiModelProperty(value = "预留字段1")
    private String extendStrOne;
	/**预留字段2*/
	@Excel(name = "预留字段2", width = 15)
    @ApiModelProperty(value = "预留字段2")
    private String extendStrTwo;
	/**预留时间1*/
	@Excel(name = "预留时间1", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "预留时间1")
    private Date extendDateOne;
	/**预留时间2*/
	@Excel(name = "预留时间2", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "预留时间2")
    private Date extendDateTwo;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**修改人*/
    @ApiModelProperty(value = "修改人")
    private String updateBy;
	/**修改时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
}
