package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 工作站点
 * @Author: jeecg-boot
 * @Date: 2024-09-02
 * @Version: V1.0
 */
@Data
@TableName("wms_station_point")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "wms_station_point对象", description = "工作站点")
public class WmsStationPoint implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
    /**
     * 工作站编码
     */
    @Excel(name = "工作站编码", width = 15)
    @ApiModelProperty(value = "工作站编码")
    private String stationCode;
    /**
     * 库位编码
     */
    @Excel(name = "库位编码", width = 15)
    @ApiModelProperty(value = "库位编码")
    private String locCode;
    /**
     * 站点编码
     */
    @Excel(name = "站点编码", width = 15)
    @ApiModelProperty(value = "站点编码")
    private String code;
    /**
     * 编号
     */
    @Excel(name = "编号", width = 15)
    @ApiModelProperty(value = "编号")
    private String number;
    /**
     * 类型
     */
    @Excel(name = "类型", width = 15,dicCode = "wms_station_point_type")
    @ApiModelProperty(value = "类型")
    @Dict(dicCode = "wms_station_point_type")
    private String type;
    /**
     * 状态
     */
    @Excel(name = "状态", width = 15,dicCode = "wms_station_point_status")
    @ApiModelProperty(value = "状态")
    @Dict(dicCode = "wms_station_point_status")
    private String pointStatus;
    /**
     * 是否启用
     */
    @Excel(name = "是否启用", width = 15,dicCode = "wms_enable_status")
    @ApiModelProperty(value = "是否启用")
    @Dict(dicCode = "wms_enable_status")
    private Integer isEnable;
    /**
     * 是否亮灯
     */
    @Excel(name = "是否亮灯", width = 15)
    @ApiModelProperty(value = "是否亮灯")
    private Integer isLight;
    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 修改人
     */
    @ApiModelProperty(value = "修改人")
    private String updateBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date updateTime;
}
