package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 工作站
 * @Author: jeecg-boot
 * @Date: 2024-09-02
 * @Version: V1.0
 */
@Data
@TableName("wms_station")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "wms_station对象", description = "工作站")
public class WmsStation implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
    /**
     * 仓库
     */
    @Excel(name = "仓库", width = 15,dicCode = "ware_code")
    @ApiModelProperty(value = "仓库")
    @Dict(dicCode = "ware_code")
    private String wareCode;
    /**
     * 站点编码
     */
    @Excel(name = "站点编码", width = 15)
    @ApiModelProperty(value = "站点编码")
    private String code;
    /**
     * IP地址
     */
    @Excel(name = "IP地址", width = 15)
    @ApiModelProperty(value = "IP地址")
    private String ipAddress;
    /**
     * 库位编码
     */
    @Excel(name = "库位编码", width = 15)
    @ApiModelProperty(value = "库位编码")
    private String locCode;
    /**
     * 楼层
     */
    @Excel(name = "楼层", width = 15)
    @ApiModelProperty(value = "楼层")
    private Integer layer;
    /**
     * 虚拟库区
     */
    @Excel(name = "虚拟库区", width = 15,dicCode = "wms_area_type")
    @ApiModelProperty(value = "虚拟库区")
    @Dict(dicCode = "wms_area_type")
    private String areaCode;
    /**
     * 实际库区
     */
    @Excel(name = "实际库区", width = 15,dicCode = "wms_direction_type")
    @ApiModelProperty(value = "实际库区")
    @Dict(dicCode = "wms_direction_type")
    private String actualArea;
    /**
     * 打印机IP
     */
    @Excel(name = "打印机IP", width = 15)
    @ApiModelProperty(value = "打印机IP")
    private String printIp;
    /**
     * 类型
     */
    @Excel(name = "类型", width = 15,dicCode = "wms_station_type")
    @ApiModelProperty(value = "类型")
    @Dict(dicCode = "wms_station_type")
    private String type;
    /**
     * 是否启用
     */
    @Excel(name = "是否启用", width = 15,dicCode = "wms_enable_status")
    @ApiModelProperty(value = "是否启用")
    @Dict(dicCode = "wms_enable_status")
    private Integer isEnable;
    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 修改人
     */
    @ApiModelProperty(value = "修改人")
    private String updateBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date updateTime;
}
