package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 出库订单
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@Data
@TableName("wms_so")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="wms_so对象", description="出库订单")
public class WmsSo implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
	/**仓库*/
	@Excel(name = "仓库", width = 15,dicCode = "ware_code")
    @ApiModelProperty(value = "仓库")
    @Dict(dicCode = "ware_code")
    private String wareCode;
	/**货主编码*/
	@Excel(name = "货主编码", width = 15)
    @ApiModelProperty(value = "货主编码")
    private String ownerCode;
	/**订单号*/
	@Excel(name = "订单号", width = 15)
    @ApiModelProperty(value = "订单号")
    private String orderNo;
	/**客户订单号*/
	@Excel(name = "客户订单号", width = 15)
    @ApiModelProperty(value = "客户订单号")
    private String customerOrderNo;
	/**状态*/
	@Excel(name = "状态", width = 15,dicCode = "wms_order_status")
    @ApiModelProperty(value = "状态")
    @Dict(dicCode = "wms_order_status")
    private String orderStatus;
	/**出入库类型*/
	@Excel(name = "出入库类型", width = 15,dicCode = "wms_so_type")
    @ApiModelProperty(value = "出入库类型")
    @Dict(dicCode = "wms_so_type")
    private String type;
	/**批次号*/
	@Excel(name = "批次号", width = 15)
    @ApiModelProperty(value = "批次号")
    private String batchNo;
	/**工作站编号*/
	@Excel(name = "工作站编号", width = 15)
    @ApiModelProperty(value = "工作站编号")
    private String stationCode;
	/**波次*/
	@Excel(name = "波次", width = 15)
    @ApiModelProperty(value = "波次")
    private String wave;
	/**优先级*/
	@Excel(name = "优先级", width = 15)
    @ApiModelProperty(value = "优先级")
    private Integer priority;
	/**执行时间*/
	@Excel(name = "执行时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "执行时间")
    private Date executeTime;
	/**完成时间*/
	@Excel(name = "完成时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "完成时间")
    private Date finishTime;
	/**创建账号*/
    @ApiModelProperty(value = "创建账号")
    private String createBy;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**修改账号*/
    @ApiModelProperty(value = "修改账号")
    private String updateBy;
	/**修改时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
	/**是否强制出库*/
	@Excel(name = "是否强制出库", width = 15)
    @ApiModelProperty(value = "是否强制出库")
    private Integer isForcedOut;
	/**单据类型*/
	@Excel(name = "单据类型", width = 15)
    @ApiModelProperty(value = "单据类型")
    private String receiptType;
}
