package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 货品SKU
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@Data
@TableName("wms_sku")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="wms_sku对象", description="货品SKU")
public class WmsSku implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
	/**仓库*/
	@Excel(name = "仓库", width = 15,dicCode = "ware_code")
    @ApiModelProperty(value = "仓库")
    @Dict(dicCode = "ware_code")
    private String wareCode;
	/**库区*/
	@Excel(name = "库区", width = 15)
    @ApiModelProperty(value = "库区")
    private String areaCode;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private String code;
	/**名称*/
	@Excel(name = "名称", width = 15)
    @ApiModelProperty(value = "名称")
    private String name;
	/**物料类型*/
	@Excel(name = "物料类型", width = 15)
    @ApiModelProperty(value = "物料类型")
    private String type;
	/**物料组*/
	@Excel(name = "物料组", width = 15)
    @ApiModelProperty(value = "物料组")
    private String goodsGroup;
	/**项目名称*/
	@Excel(name = "项目名称", width = 15)
    @ApiModelProperty(value = "项目名称")
    private String projectName;
	/**项目大类*/
	@Excel(name = "项目大类", width = 15)
    @ApiModelProperty(value = "项目大类")
    private String projectCategory;
	/**库存单位*/
	@Excel(name = "库存单位", width = 15,dicCode = "wms_stock_unit")
    @ApiModelProperty(value = "库存单位")
    @Dict(dicCode = "wms_stock_unit")
    private String stockUnit;
	/**包装单位*/
	@Excel(name = "包装单位", width = 15)
    @ApiModelProperty(value = "包装单位")
    private String packUnit;
	/**货主*/
	@Excel(name = "货主", width = 15)
    @ApiModelProperty(value = "货主")
    private String ownerCode;
	/**创建人名称*/
    @ApiModelProperty(value = "创建人名称")
    private String createBy;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**修改人名称*/
    @ApiModelProperty(value = "修改人名称")
    private String updateBy;
	/**修改时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
}
