package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 出入库流水表
 * @Author: jeecg-boot
 * @Date:   2024-09-03
 * @Version: V1.0
 */
@Data
@TableName("wms_put_and_out_record")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="wms_put_and_out_record对象", description="出入库流水表")
public class WmsPutAndOutRecord implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
	/**仓库*/
	@Excel(name = "仓库", width = 15,dicCode = "ware_code")
    @ApiModelProperty(value = "仓库")
    @Dict(dicCode = "ware_code")
    private String wareCode;
	/**虚拟库区*/
	@Excel(name = "虚拟库区", width = 15)
    @ApiModelProperty(value = "虚拟库区")
    private String areaCode;
	/**实际库区*/
	@Excel(name = "实际库区", width = 15)
    @ApiModelProperty(value = "实际库区")
    private String actualArea;
	/**出入库类型*/
	@Excel(name = "出入库类型", width = 15,dicCode = "wms_task_item_type")
    @ApiModelProperty(value = "出入库类型")
    @Dict(dicCode = "wms_task_item_type")
    private String type;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private String sku;
	/**批次号*/
	@Excel(name = "批次号", width = 15)
    @ApiModelProperty(value = "批次号")
    private String batchNo;
	/**数量*/
	@Excel(name = "数量", width = 15)
    @ApiModelProperty(value = "数量")
    private BigDecimal qty;
	/**楼层*/
	@Excel(name = "楼层", width = 15)
    @ApiModelProperty(value = "楼层")
    private Integer layer;
	/**库位*/
	@Excel(name = "库位", width = 15)
    @ApiModelProperty(value = "库位")
    private String locCode;
	/**单据类型*/
	@Excel(name = "单据类型", width = 15,dicCode = "wms_receipt_type")
    @ApiModelProperty(value = "单据类型")
    @Dict(dicCode = "wms_receipt_type")
    private String receiptType;
	/**订单号*/
	@Excel(name = "订单号", width = 15)
    @ApiModelProperty(value = "订单号")
    private String orderNo;
	/**完成时间*/
	@Excel(name = "完成时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "完成时间")
    private Date finishTime;
	/**流水时间*/
	@Excel(name = "流水时间", width = 15)
    @ApiModelProperty(value = "流水时间")
    private String recordTime;
	/**任务编码*/
	@Excel(name = "任务编码", width = 15)
    @ApiModelProperty(value = "任务编码")
    private Integer taskId;
	/**工站号*/
	@Excel(name = "工站号", width = 15)
    @ApiModelProperty(value = "工站号")
    private String stationCode;
	/**拓展字段1*/
	@Excel(name = "拓展字段1", width = 15)
    @ApiModelProperty(value = "拓展字段1")
    private String extendStrOne;
	/**拓展字段2*/
	@Excel(name = "拓展字段2", width = 15)
    @ApiModelProperty(value = "拓展字段2")
    private String extendStrTwo;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**修改人*/
    @ApiModelProperty(value = "修改人")
    private String updateBy;
	/**修改时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
}
