package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 托盘管理
 * @Author: jeecg-boot
 * @Date: 2024-09-02
 * @Version: V1.0
 */
@Data
@TableName("wms_pallet")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "wms_pallet对象", description = "托盘管理")
public class WmsPallet implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
    /**
     * 托盘编码
     */
    @Excel(name = "托盘编码", width = 15)
    @ApiModelProperty(value = "托盘编码")
    private String palletCode;
    /**
     * 库位编码
     */
    @Excel(name = "库位编码", width = 15)
    @ApiModelProperty(value = "库位编码")
    private String locCode;
    /**
     * 托盘类型
     */
    @Excel(name = "托盘类型", width = 15, dicCode = "wms_pallet_type")
    @ApiModelProperty(value = "托盘类型")
    @Dict(dicCode = "wms_pallet_type")
    private String palletType;
    /**
     * 执行任务类型
     */
    @Excel(name = "执行任务类型", width = 15, dicCode = "wms_task_type")
    @ApiModelProperty(value = "执行任务类型")
    @Dict(dicCode = "wms_task_type")
    private String execTaskType;
    /**
     * 备注
     */
    @Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private String remark;
    /**
     * 是否冻结
     */
    @Excel(name = "是否冻结", width = 15, dicCode = "wms_is_freeze")
    @ApiModelProperty(value = "是否冻结")
    @Dict(dicCode = "wms_is_freeze")
    private Integer isFreeze;
    /**
     * 状态
     */
    @Excel(name = "状态", width = 15, dicCode = "wms_pallet_status")
    @ApiModelProperty(value = "状态")
    @Dict(dicCode = "wms_pallet_status")
    private String palletStatus;
    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 修改人
     */
    @ApiModelProperty(value = "修改人")
    private String updateBy;
    /**
     * 修改时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
    /**
     * 库位编码
     */
    @ApiModelProperty(value = "库位编码")
    @TableField(exist = false)
    private String toLocCode;
}
