package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 库位管理
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@Data
@TableName("wms_loc")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="wms_loc对象", description="库位管理")
public class WmsLoc implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
	/**仓库编码*/
	@Excel(name = "仓库编码", width = 15,dicCode = "ware_code")
    @ApiModelProperty(value = "仓库编码")
    @Dict(dicCode = "ware_code")
    private String wareCode;
	/**虚拟库区*/
	@Excel(name = "虚拟库区", width = 15,dicCode = "wms_area_type")
    @ApiModelProperty(value = "虚拟库区")
    @Dict(dicCode = "wms_area_type")
    private String areaCode;
	/**实际库区*/
	@Excel(name = "实际库区", width = 15)
    @ApiModelProperty(value = "实际库区")
    private String actualArea;
	/**货架编码*/
	@Excel(name = "货架编码", width = 15)
    @ApiModelProperty(value = "货架编码")
    private String shelfCode;
	/**货主编码*/
	@Excel(name = "货主编码", width = 15)
    @ApiModelProperty(value = "货主编码")
    private String ownerCode;
	/**库位单元*/
	@Excel(name = "库位单元", width = 15)
    @ApiModelProperty(value = "库位单元")
    private String unitCode;
	/**位置*/
	@Excel(name = "位置", width = 15,dicCode = "wms_loc_site")
    @ApiModelProperty(value = "位置")
    @Dict(dicCode = "wms_loc_site")
    private String site;
	/**库位编码*/
	@Excel(name = "库位编码", width = 15)
    @ApiModelProperty(value = "库位编码")
    private String code;
	/**点位*/
	@Excel(name = "点位", width = 15)
    @ApiModelProperty(value = "点位")
    private String wcsPoint;
	/**存放状态*/
	@Excel(name = "存放状态", width = 15,dicCode = "wms_loc_status")
    @ApiModelProperty(value = "存放状态")
    @Dict(dicCode = "wms_loc_status")
    private String locStatus;
	/**类型*/
	@Excel(name = "类型", width = 15,dicCode = "wms_loc_type")
    @ApiModelProperty(value = "类型")
    @Dict(dicCode = "wms_loc_type")
    private String type;
	/**长度*/
	@Excel(name = "长度", width = 15)
    @ApiModelProperty(value = "长度")
    private BigDecimal length;
	/**宽度*/
	@Excel(name = "宽度", width = 15)
    @ApiModelProperty(value = "宽度")
    private BigDecimal width;
	/**高度*/
	@Excel(name = "高度", width = 15)
    @ApiModelProperty(value = "高度")
    private BigDecimal height;
	/**行*/
	@Excel(name = "行", width = 15)
    @ApiModelProperty(value = "行")
    private Integer locRow;
	/**列*/
	@Excel(name = "列", width = 15)
    @ApiModelProperty(value = "列")
    private Integer locColumn;
	/**层*/
	@Excel(name = "层", width = 15)
    @ApiModelProperty(value = "层")
    private Integer layer;
	/**库容*/
	@Excel(name = "库容", width = 15)
    @ApiModelProperty(value = "库容")
    private BigDecimal capacity;
	/**库容单位*/
	@Excel(name = "库容单位", width = 15)
    @ApiModelProperty(value = "库容单位")
    private String capacityUnit;
	/**是否是单深位*/
	@Excel(name = "是否是单深位", width = 15)
    @ApiModelProperty(value = "是否是单深位")
    private Integer isSingle;
	/**是否锁定*/
	@Excel(name = "是否锁定", width = 15,dicCode = "wms_lock_status")
    @ApiModelProperty(value = "是否锁定")
    @Dict(dicCode = "wms_lock_status")
    private Integer isLock;
	/**是否启用*/
	@Excel(name = "是否启用", width = 15,dicCode = "wms_enable_status")
    @ApiModelProperty(value = "是否启用")
    @Dict(dicCode = "wms_enable_status")
    private Integer isEnable;
	/**巷道*/
	@Excel(name = "巷道", width = 15)
    @ApiModelProperty(value = "巷道")
    private String tunnel;
	/**createBy*/
    @ApiModelProperty(value = "createBy")
    private String createBy;
	/**createTime*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createTime")
    private Date createTime;
	/**updateBy*/
    @ApiModelProperty(value = "updateBy")
    private String updateBy;
	/**updateTime*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updateTime")
    private Date updateTime;
}
