package org.jeecg.modules.wms.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecg.common.aspect.annotation.Dict;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 容器管理
 * @Author: jeecg-boot
 * @Date: 2024-09-02
 * @Version: V1.0
 */
@Data
@TableName("wms_container")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "wms_container对象", description = "容器管理")
public class WmsContainer implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
    /**
     * 仓库编码
     */
    @Excel(name = "仓库编码", width = 15,dicCode = "ware_code")
    @ApiModelProperty(value = "仓库编码")
    @Dict(dicCode = "ware_code")
    private String wareCode;
    /**
     * 容器编码
     */
    @Excel(name = "容器编码", width = 15)
    @ApiModelProperty(value = "容器编码")
    private String code;
    /**
     * 托盘编码
     */
    @Excel(name = "托盘编码", width = 15)
    @ApiModelProperty(value = "托盘编码")
    private String palletCode;
    /**
     * 存储类型
     */
    @Excel(name = "存储类型", width = 15,dicCode = "wms_container_storage_type")
    @ApiModelProperty(value = "存储类型")
    @Dict(dicCode = "wms_container_storage_type")
    private String storageType;
    /**
     * 尺寸
     */
    @Excel(name = "尺寸", width = 15,dicCode = "wms_box_size")
    @ApiModelProperty(value = "尺寸")
    @Dict(dicCode = "wms_box_size")
    private String size;
    /**
     * 库位编码
     */
    @Excel(name = "库位编码", width = 15)
    @ApiModelProperty(value = "库位编码")
    private String locCode;
    /**
     * 是否有货
     */
    @Excel(name = "是否有货", width = 15,dicCode = "wms_has_goods")
    @ApiModelProperty(value = "是否有货")
    @Dict(dicCode = "wms_has_goods")
    private Integer hasGoods;
    /**
     * 状态
     */
    @Excel(name = "状态", width = 15,dicCode = "wms_container_status")
    @ApiModelProperty(value = "状态")
    @Dict(dicCode = "wms_container_status")
    private String containerStatus;
    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 更新人
     */
    @ApiModelProperty(value = "更新人")
    private String updateBy;
    /**
     * 更新时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    /**
     * 目标库位
     */
    @ApiModelProperty(value = "库位编码")
    @TableField(exist = false)
    private String toLocCode;
}
