package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 盘点单详情表
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@Data
@TableName("wms_check_bill_detail")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="wms_check_bill_detail对象", description="盘点单详情表")
public class WmsCheckBillDetail implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
	/**盘点单Id*/
	@Excel(name = "盘点单Id", width = 15)
    @ApiModelProperty(value = "盘点单Id")
    private Integer orderId;
	/**箱号*/
	@Excel(name = "箱号", width = 15)
    @ApiModelProperty(value = "箱号")
    private String containerCode;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private String sku;
	/**批次号*/
	@Excel(name = "批次号", width = 15)
    @ApiModelProperty(value = "批次号")
    private String batchNo;
	/**库位编码*/
	@Excel(name = "库位编码", width = 15)
    @ApiModelProperty(value = "库位编码")
    private String locCode;
	/**WMS账存数*/
	@Excel(name = "WMS账存数", width = 15)
    @ApiModelProperty(value = "WMS账存数")
    private BigDecimal wmsAccountQty;
	/**wms库存数量*/
	@Excel(name = "wms库存数量", width = 15)
    @ApiModelProperty(value = "wms库存数量")
    private BigDecimal wmsNowQty;
	/**是否有差异*/
	@Excel(name = "是否有差异", width = 15)
    @ApiModelProperty(value = "是否有差异")
    private Integer isDiffer;
	/**拓展1*/
	@Excel(name = "拓展1", width = 15)
    @ApiModelProperty(value = "拓展1")
    private String extendStrOne;
	/**拓展2*/
	@Excel(name = "拓展2", width = 15)
    @ApiModelProperty(value = "拓展2")
    private String extendStrTwo;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**修改人*/
    @ApiModelProperty(value = "修改人")
    private String updateBy;
	/**修改时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
}
