package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 库存信息
 * @Author: jeecg-boot
 * @Date: 2024-09-03
 * @Version: V1.0
 */
@Data
@TableName("view_wms_stock_loc_sku")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "view_wms_stock_loc_sku对象", description = "库存信息")
public class ViewWmsStockLocSku implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
    /**
     * 仓库编码
     */
    @Excel(name = "仓库编码", width = 15, dicCode = "ware_code")
    @ApiModelProperty(value = "仓库编码")
    @Dict(dicCode = "ware_code")
    private String wareCode;
    /**
     * 容器编码
     */
    @Excel(name = "容器编码", width = 15)
    @ApiModelProperty(value = "容器编码")
    private String containerCode;
    /**
     * 托盘编码
     */
    @Excel(name = "托盘编码", width = 15)
    @ApiModelProperty(value = "托盘编码")
    private String palletCode;
    /**
     * 存储类型
     */
    @Excel(name = "存储类型", width = 15, dicCode = "wms_storage_type")
    @ApiModelProperty(value = "存储类型")
    @Dict(dicCode = "wms_storage_type")
    private String storageType;
    /**
     * 尺寸
     */
    @Excel(name = "尺寸", width = 15, dicCode = "wms_box_size")
    @ApiModelProperty(value = "尺寸")
    @Dict(dicCode = "wms_box_size")
    private String size;
    /**
     * 库位编码
     */
    @Excel(name = "库位编码", width = 15)
    @ApiModelProperty(value = "库位编码")
    private String locCode;
    /**
     * 容器状态
     */
    @Excel(name = "容器状态", width = 15, dicCode = "wms_container_status")
    @ApiModelProperty(value = "容器状态")
    @Dict(dicCode = "wms_container_status")
    private String containerStatus;
    /**
     * sku
     */
    @Excel(name = "sku", width = 15)
    @ApiModelProperty(value = "sku")
    private String sku;
    /**
     * 批次
     */
    @Excel(name = "批次", width = 15)
    @ApiModelProperty(value = "批次")
    private String batchNo;
    /**
     * 货品名称
     */
    @Excel(name = "货品名称", width = 15)
    @ApiModelProperty(value = "货品名称")
    private String goodsName;
    /**
     * 物料类型
     */
    @Excel(name = "物料类型", width = 15)
    @ApiModelProperty(value = "物料类型")
    private String goodsType;
    /**
     * 数量
     */
    @Excel(name = "数量", width = 15)
    @ApiModelProperty(value = "数量")
    private BigDecimal qty;
    /**
     * 接收数量
     */
    @Excel(name = "接收数量", width = 15)
    @ApiModelProperty(value = "接收数量")
    private BigDecimal qtyReceipt;
    /**
     * 分配数量
     */
    @Excel(name = "分配数量", width = 15)
    @ApiModelProperty(value = "分配数量")
    private BigDecimal qtyAllocated;
    /**
     * 单位
     */
    @Excel(name = "单位", width = 15, dicCode = "wms_stock_unit")
    @ApiModelProperty(value = "单位")
    @Dict(dicCode = "wms_stock_unit")
    private String unit;
    /**
     * 状态
     */
    @Excel(name = "状态", width = 15, dicCode = "wms_container_status")
    @ApiModelProperty(value = "状态")
    private String goodsStatus;
    /**
     * 上次盘点时间
     */
    @Excel(name = "上次盘点时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "上次盘点时间")
    private Date lastCheckedTime;
    /**
     * 预留字段1
     */
    @Excel(name = "预留字段1", width = 15)
    @ApiModelProperty(value = "预留字段1")
    private String extendStrOne;
    /**
     * 预留字段2
     */
    @Excel(name = "预留字段2", width = 15)
    @ApiModelProperty(value = "预留字段2")
    private String extendStrTwo;
    /**
     * 预留时间1
     */
    @Excel(name = "预留时间1", width = 20, format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "预留时间1")
    private Date extendDateOne;
    /**
     * 预留时间2
     */
    @Excel(name = "预留时间2", width = 20, format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "预留时间2")
    private Date extendDateTwo;
    /**
     * createBy
     */
    @ApiModelProperty(value = "createBy")
    private String createBy;
    /**
     * createTime
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createTime")
    private Date createTime;
    /**
     * updateBy
     */
    @ApiModelProperty(value = "updateBy")
    private String updateBy;
    /**
     * updateTime
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updateTime")
    private Date updateTime;
    /**
     * 物料组
     */
    @Excel(name = "物料组", width = 15)
    @ApiModelProperty(value = "物料组")
    private String goodsGroup;
    /**
     * 项目名称
     */
    @Excel(name = "项目名称", width = 15)
    @ApiModelProperty(value = "项目名称")
    private String projectName;
    /**
     * 项目大类
     */
    @Excel(name = "项目大类", width = 15)
    @ApiModelProperty(value = "项目大类")
    private String projectCategory;
}
