package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.XhSortLoc;
import org.jeecg.modules.wms.service.IXhSortLocService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 分拣区库位
 * @Author: jeecg-boot
 * @Date:   2024-11-11
 * @Version: V1.0
 */
@Api(tags="分拣区库位")
@RestController
@RequestMapping("/wms/xhSortLoc")
@Slf4j
public class XhSortLocController extends JeecgController<XhSortLoc, IXhSortLocService> {
	@Autowired
	private IXhSortLocService xhSortLocService;
	
	/**
	 * 分页列表查询
	 *
	 * @param xhSortLoc
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "分拣区库位-分页列表查询")
	@ApiOperation(value="分拣区库位-分页列表查询", notes="分拣区库位-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<XhSortLoc>> queryPageList(XhSortLoc xhSortLoc,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<XhSortLoc> queryWrapper = QueryGenerator.initQueryWrapper(xhSortLoc, req.getParameterMap());
		Page<XhSortLoc> page = new Page<XhSortLoc>(pageNo, pageSize);
		IPage<XhSortLoc> pageList = xhSortLocService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param xhSortLoc
	 * @return
	 */
	@AutoLog(value = "分拣区库位-添加")
	@ApiOperation(value="分拣区库位-添加", notes="分拣区库位-添加")
	@RequiresPermissions("wms:xh_sort_loc:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody XhSortLoc xhSortLoc) {
		xhSortLocService.save(xhSortLoc);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param xhSortLoc
	 * @return
	 */
	@AutoLog(value = "分拣区库位-编辑")
	@ApiOperation(value="分拣区库位-编辑", notes="分拣区库位-编辑")
	@RequiresPermissions("wms:xh_sort_loc:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody XhSortLoc xhSortLoc) {
		xhSortLocService.updateById(xhSortLoc);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "分拣区库位-通过id删除")
	@ApiOperation(value="分拣区库位-通过id删除", notes="分拣区库位-通过id删除")
	@RequiresPermissions("wms:xh_sort_loc:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		xhSortLocService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "分拣区库位-批量删除")
	@ApiOperation(value="分拣区库位-批量删除", notes="分拣区库位-批量删除")
	@RequiresPermissions("wms:xh_sort_loc:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.xhSortLocService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "分拣区库位-通过id查询")
	@ApiOperation(value="分拣区库位-通过id查询", notes="分拣区库位-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<XhSortLoc> queryById(@RequestParam(name="id",required=true) String id) {
		XhSortLoc xhSortLoc = xhSortLocService.getById(id);
		if(xhSortLoc==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(xhSortLoc);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param xhSortLoc
    */
    @RequiresPermissions("wms:xh_sort_loc:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, XhSortLoc xhSortLoc) {
        return super.exportXls(request, xhSortLoc, XhSortLoc.class, "分拣区库位");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:xh_sort_loc:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, XhSortLoc.class);
    }

}
