package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.XhOutOrderRequirementItem;
import org.jeecg.modules.wms.service.IXhOutOrderRequirementItemService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 鑫泓出库需求单明细
 * @Author: jeecg-boot
 * @Date:   2024-11-10
 * @Version: V1.0
 */
@Api(tags="鑫泓出库需求单明细")
@RestController
@RequestMapping("/wms/xhOutOrderRequirementItem")
@Slf4j
public class XhOutOrderRequirementItemController extends JeecgController<XhOutOrderRequirementItem, IXhOutOrderRequirementItemService> {
	@Autowired
	private IXhOutOrderRequirementItemService xhOutOrderRequirementItemService;
	
	/**
	 * 分页列表查询
	 *
	 * @param xhOutOrderRequirementItem
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "鑫泓出库需求单明细-分页列表查询")
	@ApiOperation(value="鑫泓出库需求单明细-分页列表查询", notes="鑫泓出库需求单明细-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<XhOutOrderRequirementItem>> queryPageList(XhOutOrderRequirementItem xhOutOrderRequirementItem,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<XhOutOrderRequirementItem> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderRequirementItem, req.getParameterMap());
		Page<XhOutOrderRequirementItem> page = new Page<XhOutOrderRequirementItem>(pageNo, pageSize);
		IPage<XhOutOrderRequirementItem> pageList = xhOutOrderRequirementItemService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param xhOutOrderRequirementItem
	 * @return
	 */
	@AutoLog(value = "鑫泓出库需求单明细-添加")
	@ApiOperation(value="鑫泓出库需求单明细-添加", notes="鑫泓出库需求单明细-添加")
	@RequiresPermissions("wms:xh_out_order_requirement_item:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody XhOutOrderRequirementItem xhOutOrderRequirementItem) {
		xhOutOrderRequirementItemService.save(xhOutOrderRequirementItem);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param xhOutOrderRequirementItem
	 * @return
	 */
	@AutoLog(value = "鑫泓出库需求单明细-编辑")
	@ApiOperation(value="鑫泓出库需求单明细-编辑", notes="鑫泓出库需求单明细-编辑")
	@RequiresPermissions("wms:xh_out_order_requirement_item:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody XhOutOrderRequirementItem xhOutOrderRequirementItem) {
		xhOutOrderRequirementItemService.updateById(xhOutOrderRequirementItem);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "鑫泓出库需求单明细-通过id删除")
	@ApiOperation(value="鑫泓出库需求单明细-通过id删除", notes="鑫泓出库需求单明细-通过id删除")
	@RequiresPermissions("wms:xh_out_order_requirement_item:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		xhOutOrderRequirementItemService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "鑫泓出库需求单明细-批量删除")
	@ApiOperation(value="鑫泓出库需求单明细-批量删除", notes="鑫泓出库需求单明细-批量删除")
	@RequiresPermissions("wms:xh_out_order_requirement_item:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.xhOutOrderRequirementItemService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "鑫泓出库需求单明细-通过id查询")
	@ApiOperation(value="鑫泓出库需求单明细-通过id查询", notes="鑫泓出库需求单明细-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<XhOutOrderRequirementItem> queryById(@RequestParam(name="id",required=true) String id) {
		XhOutOrderRequirementItem xhOutOrderRequirementItem = xhOutOrderRequirementItemService.getById(id);
		if(xhOutOrderRequirementItem==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(xhOutOrderRequirementItem);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param xhOutOrderRequirementItem
    */
    @RequiresPermissions("wms:xh_out_order_requirement_item:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, XhOutOrderRequirementItem xhOutOrderRequirementItem) {
        return super.exportXls(request, xhOutOrderRequirementItem, XhOutOrderRequirementItem.class, "鑫泓出库需求单明细");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:xh_out_order_requirement_item:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, XhOutOrderRequirementItem.class);
    }

}
