package org.jeecg.modules.wms.controller;

import org.jeecg.common.system.query.QueryGenerator;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.api.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import java.util.Arrays;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.XhOutOrderRequirementItem;
import org.jeecg.modules.wms.entity.XhOutOrderRequirement;
import org.jeecg.modules.wms.service.IXhOutOrderRequirementService;
import org.jeecg.modules.wms.service.IXhOutOrderRequirementItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 鑫泓出库需求单
 * @Author: jeecg-boot
 * @Date:   2024-11-10
 * @Version: V1.0
 */
@Api(tags="鑫泓出库需求单")
@RestController
@RequestMapping("/wms/xhOutOrderRequirement")
@Slf4j
public class XhOutOrderRequirementController extends JeecgController<XhOutOrderRequirement, IXhOutOrderRequirementService> {

	@Autowired
	private IXhOutOrderRequirementService xhOutOrderRequirementService;

	@Autowired
	private IXhOutOrderRequirementItemService xhOutOrderRequirementItemService;


	/*---------------------------------主表处理-begin-------------------------------------*/

	/**
	 * 分页列表查询
	 * @param xhOutOrderRequirement
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "鑫泓出库需求单-分页列表查询")
	@ApiOperation(value="鑫泓出库需求单-分页列表查询", notes="鑫泓出库需求单-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<XhOutOrderRequirement>> queryPageList(XhOutOrderRequirement xhOutOrderRequirement,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<XhOutOrderRequirement> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderRequirement, req.getParameterMap());
		Page<XhOutOrderRequirement> page = new Page<XhOutOrderRequirement>(pageNo, pageSize);
		IPage<XhOutOrderRequirement> pageList = xhOutOrderRequirementService.page(page, queryWrapper);
		return Result.OK(pageList);
	}

	/**
     *   添加
     * @param xhOutOrderRequirement
     * @return
     */
    @AutoLog(value = "鑫泓出库需求单-添加")
    @ApiOperation(value="鑫泓出库需求单-添加", notes="鑫泓出库需求单-添加")
    @RequiresPermissions("wms:xh_out_order_requirement:add")
    @PostMapping(value = "/add")
    public Result<String> add(@RequestBody XhOutOrderRequirement xhOutOrderRequirement) {
        xhOutOrderRequirementService.save(xhOutOrderRequirement);
        return Result.OK("添加成功！");
    }

    /**
     *  编辑
     * @param xhOutOrderRequirement
     * @return
     */
    @AutoLog(value = "鑫泓出库需求单-编辑")
    @ApiOperation(value="鑫泓出库需求单-编辑", notes="鑫泓出库需求单-编辑")
    @RequiresPermissions("wms:xh_out_order_requirement:edit")
    @RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
    public Result<String> edit(@RequestBody XhOutOrderRequirement xhOutOrderRequirement) {
        xhOutOrderRequirementService.updateById(xhOutOrderRequirement);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     * @param id
     * @return
     */
    @AutoLog(value = "鑫泓出库需求单-通过id删除")
    @ApiOperation(value="鑫泓出库需求单-通过id删除", notes="鑫泓出库需求单-通过id删除")
    @RequiresPermissions("wms:xh_out_order_requirement:delete")
    @DeleteMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name="id",required=true) String id) {
        xhOutOrderRequirementService.delMain(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @AutoLog(value = "鑫泓出库需求单-批量删除")
    @ApiOperation(value="鑫泓出库需求单-批量删除", notes="鑫泓出库需求单-批量删除")
    @RequiresPermissions("wms:xh_out_order_requirement:deleteBatch")
    @DeleteMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
        this.xhOutOrderRequirementService.delBatchMain(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 导出
     * @return
     */
    @RequiresPermissions("wms:xh_out_order_requirement:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, XhOutOrderRequirement xhOutOrderRequirement) {
        return super.exportXls(request, xhOutOrderRequirement, XhOutOrderRequirement.class, "鑫泓出库需求单");
    }

    /**
     * 导入
     * @return
     */
    @RequiresPermissions("wms:xh_out_order_requirement:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, XhOutOrderRequirement.class);
    }
	/*---------------------------------主表处理-end-------------------------------------*/
	

    /*--------------------------------子表处理-鑫泓出库需求单明细-begin----------------------------------------------*/
	/**
	 * 通过主表ID查询
	 * @return
	 */
	//@AutoLog(value = "鑫泓出库需求单明细-通过主表ID查询")
	@ApiOperation(value="鑫泓出库需求单明细-通过主表ID查询", notes="鑫泓出库需求单明细-通过主表ID查询")
	@GetMapping(value = "/listXhOutOrderRequirementItemByMainId")
    public Result<IPage<XhOutOrderRequirementItem>> listXhOutOrderRequirementItemByMainId(XhOutOrderRequirementItem xhOutOrderRequirementItem,
                                                    @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                    @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                    HttpServletRequest req) {
        QueryWrapper<XhOutOrderRequirementItem> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderRequirementItem, req.getParameterMap());
        Page<XhOutOrderRequirementItem> page = new Page<XhOutOrderRequirementItem>(pageNo, pageSize);
        IPage<XhOutOrderRequirementItem> pageList = xhOutOrderRequirementItemService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

	/**
	 * 添加
	 * @param xhOutOrderRequirementItem
	 * @return
	 */
	@AutoLog(value = "鑫泓出库需求单明细-添加")
	@ApiOperation(value="鑫泓出库需求单明细-添加", notes="鑫泓出库需求单明细-添加")
	@PostMapping(value = "/addXhOutOrderRequirementItem")
	public Result<String> addXhOutOrderRequirementItem(@RequestBody XhOutOrderRequirementItem xhOutOrderRequirementItem) {
		xhOutOrderRequirementItemService.save(xhOutOrderRequirementItem);
		return Result.OK("添加成功！");
	}

    /**
	 * 编辑
	 * @param xhOutOrderRequirementItem
	 * @return
	 */
	@AutoLog(value = "鑫泓出库需求单明细-编辑")
	@ApiOperation(value="鑫泓出库需求单明细-编辑", notes="鑫泓出库需求单明细-编辑")
	@RequestMapping(value = "/editXhOutOrderRequirementItem", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> editXhOutOrderRequirementItem(@RequestBody XhOutOrderRequirementItem xhOutOrderRequirementItem) {
		xhOutOrderRequirementItemService.updateById(xhOutOrderRequirementItem);
		return Result.OK("编辑成功!");
	}

	/**
	 * 通过id删除
	 * @param id
	 * @return
	 */
	@AutoLog(value = "鑫泓出库需求单明细-通过id删除")
	@ApiOperation(value="鑫泓出库需求单明细-通过id删除", notes="鑫泓出库需求单明细-通过id删除")
	@DeleteMapping(value = "/deleteXhOutOrderRequirementItem")
	public Result<String> deleteXhOutOrderRequirementItem(@RequestParam(name="id",required=true) String id) {
		xhOutOrderRequirementItemService.removeById(id);
		return Result.OK("删除成功!");
	}

	/**
	 * 批量删除
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "鑫泓出库需求单明细-批量删除")
	@ApiOperation(value="鑫泓出库需求单明细-批量删除", notes="鑫泓出库需求单明细-批量删除")
	@DeleteMapping(value = "/deleteBatchXhOutOrderRequirementItem")
	public Result<String> deleteBatchXhOutOrderRequirementItem(@RequestParam(name="ids",required=true) String ids) {
	    this.xhOutOrderRequirementItemService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}

    /**
     * 导出
     * @return
     */
    @RequestMapping(value = "/exportXhOutOrderRequirementItem")
    public ModelAndView exportXhOutOrderRequirementItem(HttpServletRequest request, XhOutOrderRequirementItem xhOutOrderRequirementItem) {
		 // Step.1 组装查询条件
		 QueryWrapper<XhOutOrderRequirementItem> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderRequirementItem, request.getParameterMap());
		 LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

		 // Step.2 获取导出数据
		 List<XhOutOrderRequirementItem> pageList = xhOutOrderRequirementItemService.list(queryWrapper);
		 List<XhOutOrderRequirementItem> exportList = null;

		 // 过滤选中数据
		 String selections = request.getParameter("selections");
		 if (oConvertUtils.isNotEmpty(selections)) {
			 List<String> selectionList = Arrays.asList(selections.split(","));
			 exportList = pageList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
		 } else {
			 exportList = pageList;
		 }

		 // Step.3 AutoPoi 导出Excel
		 ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
		 //此处设置的filename无效,前端会重更新设置一下
		 mv.addObject(NormalExcelConstants.FILE_NAME, "鑫泓出库需求单明细");
		 mv.addObject(NormalExcelConstants.CLASS, XhOutOrderRequirementItem.class);
		 mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("鑫泓出库需求单明细报表", "导出人:" + sysUser.getRealname(), "鑫泓出库需求单明细"));
		 mv.addObject(NormalExcelConstants.DATA_LIST, exportList);
		 return mv;
    }

    /**
     * 导入
     * @return
     */
    @RequestMapping(value = "/importXhOutOrderRequirementItem/{mainId}")
    public Result<?> importXhOutOrderRequirementItem(HttpServletRequest request, HttpServletResponse response, @PathVariable("mainId") String mainId) {
		 MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		 Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		 for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
       // 获取上传文件对象
			 MultipartFile file = entity.getValue();
			 ImportParams params = new ImportParams();
			 params.setTitleRows(2);
			 params.setHeadRows(1);
			 params.setNeedSave(true);
			 try {
				 List<XhOutOrderRequirementItem> list = ExcelImportUtil.importExcel(file.getInputStream(), XhOutOrderRequirementItem.class, params);
				 for (XhOutOrderRequirementItem temp : list) {
                    temp.setOrderNo(mainId);
				 }
				 long start = System.currentTimeMillis();
				 xhOutOrderRequirementItemService.saveBatch(list);
				 log.info("消耗时间" + (System.currentTimeMillis() - start) + "毫秒");
				 return Result.OK("文件导入成功！数据行数：" + list.size());
			 } catch (Exception e) {
				 log.error(e.getMessage(), e);
				 return Result.error("文件导入失败:" + e.getMessage());
			 } finally {
				 try {
					 file.getInputStream().close();
				 } catch (IOException e) {
					 e.printStackTrace();
				 }
			 }
		 }
		 return Result.error("文件导入失败！");
    }

    /*--------------------------------子表处理-鑫泓出库需求单明细-end----------------------------------------------*/




}
