package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.XhOutOrderPallet;
import org.jeecg.modules.wms.service.IXhOutOrderPalletService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 托盘出库信息
 * @Author: jeecg-boot
 * @Date:   2024-08-28
 * @Version: V1.0
 */
@Api(tags="托盘出库信息")
@RestController
@RequestMapping("/wms/xhOutOrderPallet")
@Slf4j
public class XhOutOrderPalletController extends JeecgController<XhOutOrderPallet, IXhOutOrderPalletService> {
	@Autowired
	private IXhOutOrderPalletService xhOutOrderPalletService;
	
	/**
	 * 分页列表查询
	 *
	 * @param xhOutOrderPallet
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "托盘出库信息-分页列表查询")
	@ApiOperation(value="托盘出库信息-分页列表查询", notes="托盘出库信息-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<XhOutOrderPallet>> queryPageList(XhOutOrderPallet xhOutOrderPallet,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<XhOutOrderPallet> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderPallet, req.getParameterMap());
		Page<XhOutOrderPallet> page = new Page<XhOutOrderPallet>(pageNo, pageSize);
		IPage<XhOutOrderPallet> pageList = xhOutOrderPalletService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param xhOutOrderPallet
	 * @return
	 */
	@AutoLog(value = "托盘出库信息-添加")
	@ApiOperation(value="托盘出库信息-添加", notes="托盘出库信息-添加")
	@RequiresPermissions("wms:xh_out_order_pallet:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody XhOutOrderPallet xhOutOrderPallet) {
		xhOutOrderPalletService.save(xhOutOrderPallet);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param xhOutOrderPallet
	 * @return
	 */
	@AutoLog(value = "托盘出库信息-编辑")
	@ApiOperation(value="托盘出库信息-编辑", notes="托盘出库信息-编辑")
	@RequiresPermissions("wms:xh_out_order_pallet:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody XhOutOrderPallet xhOutOrderPallet) {
		xhOutOrderPalletService.updateById(xhOutOrderPallet);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "托盘出库信息-通过id删除")
	@ApiOperation(value="托盘出库信息-通过id删除", notes="托盘出库信息-通过id删除")
	@RequiresPermissions("wms:xh_out_order_pallet:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		xhOutOrderPalletService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "托盘出库信息-批量删除")
	@ApiOperation(value="托盘出库信息-批量删除", notes="托盘出库信息-批量删除")
	@RequiresPermissions("wms:xh_out_order_pallet:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.xhOutOrderPalletService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "托盘出库信息-通过id查询")
	@ApiOperation(value="托盘出库信息-通过id查询", notes="托盘出库信息-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<XhOutOrderPallet> queryById(@RequestParam(name="id",required=true) String id) {
		XhOutOrderPallet xhOutOrderPallet = xhOutOrderPalletService.getById(id);
		if(xhOutOrderPallet==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(xhOutOrderPallet);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param xhOutOrderPallet
    */
    @RequiresPermissions("wms:xh_out_order_pallet:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, XhOutOrderPallet xhOutOrderPallet) {
        return super.exportXls(request, xhOutOrderPallet, XhOutOrderPallet.class, "托盘出库信息");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:xh_out_order_pallet:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, XhOutOrderPallet.class);
    }

}
