package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.XhOutOrderFirstPick;
import org.jeecg.modules.wms.service.IXhOutOrderFirstPickService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 初次拣选物料信息
 * @Author: jeecg-boot
 * @Date:   2024-08-28
 * @Version: V1.0
 */
@Api(tags="初次拣选物料信息")
@RestController
@RequestMapping("/wms/xhOutOrderFirstPick")
@Slf4j
public class XhOutOrderFirstPickController extends JeecgController<XhOutOrderFirstPick, IXhOutOrderFirstPickService> {
	@Autowired
	private IXhOutOrderFirstPickService xhOutOrderFirstPickService;
	
	/**
	 * 分页列表查询
	 *
	 * @param xhOutOrderFirstPick
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "初次拣选物料信息-分页列表查询")
	@ApiOperation(value="初次拣选物料信息-分页列表查询", notes="初次拣选物料信息-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<XhOutOrderFirstPick>> queryPageList(XhOutOrderFirstPick xhOutOrderFirstPick,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<XhOutOrderFirstPick> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderFirstPick, req.getParameterMap());
		Page<XhOutOrderFirstPick> page = new Page<XhOutOrderFirstPick>(pageNo, pageSize);
		IPage<XhOutOrderFirstPick> pageList = xhOutOrderFirstPickService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param xhOutOrderFirstPick
	 * @return
	 */
	@AutoLog(value = "初次拣选物料信息-添加")
	@ApiOperation(value="初次拣选物料信息-添加", notes="初次拣选物料信息-添加")
	@RequiresPermissions("wms:xh_out_order_first_pick:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody XhOutOrderFirstPick xhOutOrderFirstPick) {
		xhOutOrderFirstPickService.save(xhOutOrderFirstPick);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param xhOutOrderFirstPick
	 * @return
	 */
	@AutoLog(value = "初次拣选物料信息-编辑")
	@ApiOperation(value="初次拣选物料信息-编辑", notes="初次拣选物料信息-编辑")
	@RequiresPermissions("wms:xh_out_order_first_pick:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody XhOutOrderFirstPick xhOutOrderFirstPick) {
		xhOutOrderFirstPickService.updateById(xhOutOrderFirstPick);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "初次拣选物料信息-通过id删除")
	@ApiOperation(value="初次拣选物料信息-通过id删除", notes="初次拣选物料信息-通过id删除")
	@RequiresPermissions("wms:xh_out_order_first_pick:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		xhOutOrderFirstPickService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "初次拣选物料信息-批量删除")
	@ApiOperation(value="初次拣选物料信息-批量删除", notes="初次拣选物料信息-批量删除")
	@RequiresPermissions("wms:xh_out_order_first_pick:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.xhOutOrderFirstPickService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "初次拣选物料信息-通过id查询")
	@ApiOperation(value="初次拣选物料信息-通过id查询", notes="初次拣选物料信息-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<XhOutOrderFirstPick> queryById(@RequestParam(name="id",required=true) String id) {
		XhOutOrderFirstPick xhOutOrderFirstPick = xhOutOrderFirstPickService.getById(id);
		if(xhOutOrderFirstPick==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(xhOutOrderFirstPick);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param xhOutOrderFirstPick
    */
    @RequiresPermissions("wms:xh_out_order_first_pick:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, XhOutOrderFirstPick xhOutOrderFirstPick) {
        return super.exportXls(request, xhOutOrderFirstPick, XhOutOrderFirstPick.class, "初次拣选物料信息");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:xh_out_order_first_pick:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, XhOutOrderFirstPick.class);
    }

}
