package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.XhOutOrderDeliveryItem;
import org.jeecg.modules.wms.service.IXhOutOrderDeliveryItemService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 鑫宏配送单明细
 * @Author: jeecg-boot
 * @Date:   2024-11-29
 * @Version: V1.0
 */
@Api(tags="鑫宏配送单明细")
@RestController
@RequestMapping("/wms/xhOutOrderDeliveryItem")
@Slf4j
public class XhOutOrderDeliveryItemController extends JeecgController<XhOutOrderDeliveryItem, IXhOutOrderDeliveryItemService> {
	@Autowired
	private IXhOutOrderDeliveryItemService xhOutOrderDeliveryItemService;
	
	/**
	 * 分页列表查询
	 *
	 * @param xhOutOrderDeliveryItem
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "鑫宏配送单明细-分页列表查询")
	@ApiOperation(value="鑫宏配送单明细-分页列表查询", notes="鑫宏配送单明细-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<XhOutOrderDeliveryItem>> queryPageList(XhOutOrderDeliveryItem xhOutOrderDeliveryItem,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<XhOutOrderDeliveryItem> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderDeliveryItem, req.getParameterMap());
		Page<XhOutOrderDeliveryItem> page = new Page<XhOutOrderDeliveryItem>(pageNo, pageSize);
		IPage<XhOutOrderDeliveryItem> pageList = xhOutOrderDeliveryItemService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param xhOutOrderDeliveryItem
	 * @return
	 */
	@AutoLog(value = "鑫宏配送单明细-添加")
	@ApiOperation(value="鑫宏配送单明细-添加", notes="鑫宏配送单明细-添加")
	@RequiresPermissions("wms:xh_out_order_delivery_item:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody XhOutOrderDeliveryItem xhOutOrderDeliveryItem) {
		xhOutOrderDeliveryItemService.save(xhOutOrderDeliveryItem);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param xhOutOrderDeliveryItem
	 * @return
	 */
	@AutoLog(value = "鑫宏配送单明细-编辑")
	@ApiOperation(value="鑫宏配送单明细-编辑", notes="鑫宏配送单明细-编辑")
	@RequiresPermissions("wms:xh_out_order_delivery_item:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody XhOutOrderDeliveryItem xhOutOrderDeliveryItem) {
		xhOutOrderDeliveryItemService.updateById(xhOutOrderDeliveryItem);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "鑫宏配送单明细-通过id删除")
	@ApiOperation(value="鑫宏配送单明细-通过id删除", notes="鑫宏配送单明细-通过id删除")
	@RequiresPermissions("wms:xh_out_order_delivery_item:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		xhOutOrderDeliveryItemService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "鑫宏配送单明细-批量删除")
	@ApiOperation(value="鑫宏配送单明细-批量删除", notes="鑫宏配送单明细-批量删除")
	@RequiresPermissions("wms:xh_out_order_delivery_item:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.xhOutOrderDeliveryItemService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "鑫宏配送单明细-通过id查询")
	@ApiOperation(value="鑫宏配送单明细-通过id查询", notes="鑫宏配送单明细-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<XhOutOrderDeliveryItem> queryById(@RequestParam(name="id",required=true) String id) {
		XhOutOrderDeliveryItem xhOutOrderDeliveryItem = xhOutOrderDeliveryItemService.getById(id);
		if(xhOutOrderDeliveryItem==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(xhOutOrderDeliveryItem);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param xhOutOrderDeliveryItem
    */
    @RequiresPermissions("wms:xh_out_order_delivery_item:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, XhOutOrderDeliveryItem xhOutOrderDeliveryItem) {
        return super.exportXls(request, xhOutOrderDeliveryItem, XhOutOrderDeliveryItem.class, "鑫宏配送单明细");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:xh_out_order_delivery_item:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, XhOutOrderDeliveryItem.class);
    }

}
