package org.jeecg.modules.wms.controller;

import org.jeecg.common.system.query.QueryGenerator;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.api.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import java.util.Arrays;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.XhOutOrderDeliveryItem;
import org.jeecg.modules.wms.entity.XhOutOrderDelivery;
import org.jeecg.modules.wms.service.IXhOutOrderDeliveryService;
import org.jeecg.modules.wms.service.IXhOutOrderDeliveryItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 鑫宏配送单
 * @Author: jeecg-boot
 * @Date:   2024-11-29
 * @Version: V1.0
 */
@Api(tags="鑫宏配送单")
@RestController
@RequestMapping("/wms/xhOutOrderDelivery")
@Slf4j
public class XhOutOrderDeliveryController extends JeecgController<XhOutOrderDelivery, IXhOutOrderDeliveryService> {

	@Autowired
	private IXhOutOrderDeliveryService xhOutOrderDeliveryService;

	@Autowired
	private IXhOutOrderDeliveryItemService xhOutOrderDeliveryItemService;


	/*---------------------------------主表处理-begin-------------------------------------*/

	/**
	 * 分页列表查询
	 * @param xhOutOrderDelivery
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "鑫宏配送单-分页列表查询")
	@ApiOperation(value="鑫宏配送单-分页列表查询", notes="鑫宏配送单-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<XhOutOrderDelivery>> queryPageList(XhOutOrderDelivery xhOutOrderDelivery,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<XhOutOrderDelivery> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderDelivery, req.getParameterMap());
		Page<XhOutOrderDelivery> page = new Page<XhOutOrderDelivery>(pageNo, pageSize);
		IPage<XhOutOrderDelivery> pageList = xhOutOrderDeliveryService.page(page, queryWrapper);
		return Result.OK(pageList);
	}

	/**
     *   添加
     * @param xhOutOrderDelivery
     * @return
     */
    @AutoLog(value = "鑫宏配送单-添加")
    @ApiOperation(value="鑫宏配送单-添加", notes="鑫宏配送单-添加")
    @RequiresPermissions("wms:xh_out_order_delivery:add")
    @PostMapping(value = "/add")
    public Result<String> add(@RequestBody XhOutOrderDelivery xhOutOrderDelivery) {
        xhOutOrderDeliveryService.save(xhOutOrderDelivery);
        return Result.OK("添加成功！");
    }

    /**
     *  编辑
     * @param xhOutOrderDelivery
     * @return
     */
    @AutoLog(value = "鑫宏配送单-编辑")
    @ApiOperation(value="鑫宏配送单-编辑", notes="鑫宏配送单-编辑")
    @RequiresPermissions("wms:xh_out_order_delivery:edit")
    @RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
    public Result<String> edit(@RequestBody XhOutOrderDelivery xhOutOrderDelivery) {
        xhOutOrderDeliveryService.updateById(xhOutOrderDelivery);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     * @param id
     * @return
     */
    @AutoLog(value = "鑫宏配送单-通过id删除")
    @ApiOperation(value="鑫宏配送单-通过id删除", notes="鑫宏配送单-通过id删除")
    @RequiresPermissions("wms:xh_out_order_delivery:delete")
    @DeleteMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name="id",required=true) String id) {
        xhOutOrderDeliveryService.delMain(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @AutoLog(value = "鑫宏配送单-批量删除")
    @ApiOperation(value="鑫宏配送单-批量删除", notes="鑫宏配送单-批量删除")
    @RequiresPermissions("wms:xh_out_order_delivery:deleteBatch")
    @DeleteMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
        this.xhOutOrderDeliveryService.delBatchMain(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 导出
     * @return
     */
    @RequiresPermissions("wms:xh_out_order_delivery:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, XhOutOrderDelivery xhOutOrderDelivery) {
        return super.exportXls(request, xhOutOrderDelivery, XhOutOrderDelivery.class, "鑫宏配送单");
    }

    /**
     * 导入
     * @return
     */
    @RequiresPermissions("wms:xh_out_order_delivery:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, XhOutOrderDelivery.class);
    }
	/*---------------------------------主表处理-end-------------------------------------*/
	

    /*--------------------------------子表处理-鑫宏配送单明细-begin----------------------------------------------*/
	/**
	 * 通过主表ID查询
	 * @return
	 */
	//@AutoLog(value = "鑫宏配送单明细-通过主表ID查询")
	@ApiOperation(value="鑫宏配送单明细-通过主表ID查询", notes="鑫宏配送单明细-通过主表ID查询")
	@GetMapping(value = "/listXhOutOrderDeliveryItemByMainId")
    public Result<IPage<XhOutOrderDeliveryItem>> listXhOutOrderDeliveryItemByMainId(XhOutOrderDeliveryItem xhOutOrderDeliveryItem,
                                                    @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                    @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                    HttpServletRequest req) {
        QueryWrapper<XhOutOrderDeliveryItem> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderDeliveryItem, req.getParameterMap());
        Page<XhOutOrderDeliveryItem> page = new Page<XhOutOrderDeliveryItem>(pageNo, pageSize);
        IPage<XhOutOrderDeliveryItem> pageList = xhOutOrderDeliveryItemService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

	/**
	 * 添加
	 * @param xhOutOrderDeliveryItem
	 * @return
	 */
	@AutoLog(value = "鑫宏配送单明细-添加")
	@ApiOperation(value="鑫宏配送单明细-添加", notes="鑫宏配送单明细-添加")
	@PostMapping(value = "/addXhOutOrderDeliveryItem")
	public Result<String> addXhOutOrderDeliveryItem(@RequestBody XhOutOrderDeliveryItem xhOutOrderDeliveryItem) {
		xhOutOrderDeliveryItemService.save(xhOutOrderDeliveryItem);
		return Result.OK("添加成功！");
	}

    /**
	 * 编辑
	 * @param xhOutOrderDeliveryItem
	 * @return
	 */
	@AutoLog(value = "鑫宏配送单明细-编辑")
	@ApiOperation(value="鑫宏配送单明细-编辑", notes="鑫宏配送单明细-编辑")
	@RequestMapping(value = "/editXhOutOrderDeliveryItem", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> editXhOutOrderDeliveryItem(@RequestBody XhOutOrderDeliveryItem xhOutOrderDeliveryItem) {
		xhOutOrderDeliveryItemService.updateById(xhOutOrderDeliveryItem);
		return Result.OK("编辑成功!");
	}

	/**
	 * 通过id删除
	 * @param id
	 * @return
	 */
	@AutoLog(value = "鑫宏配送单明细-通过id删除")
	@ApiOperation(value="鑫宏配送单明细-通过id删除", notes="鑫宏配送单明细-通过id删除")
	@DeleteMapping(value = "/deleteXhOutOrderDeliveryItem")
	public Result<String> deleteXhOutOrderDeliveryItem(@RequestParam(name="id",required=true) String id) {
		xhOutOrderDeliveryItemService.removeById(id);
		return Result.OK("删除成功!");
	}

	/**
	 * 批量删除
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "鑫宏配送单明细-批量删除")
	@ApiOperation(value="鑫宏配送单明细-批量删除", notes="鑫宏配送单明细-批量删除")
	@DeleteMapping(value = "/deleteBatchXhOutOrderDeliveryItem")
	public Result<String> deleteBatchXhOutOrderDeliveryItem(@RequestParam(name="ids",required=true) String ids) {
	    this.xhOutOrderDeliveryItemService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}

    /**
     * 导出
     * @return
     */
    @RequestMapping(value = "/exportXhOutOrderDeliveryItem")
    public ModelAndView exportXhOutOrderDeliveryItem(HttpServletRequest request, XhOutOrderDeliveryItem xhOutOrderDeliveryItem) {
		 // Step.1 组装查询条件
		 QueryWrapper<XhOutOrderDeliveryItem> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderDeliveryItem, request.getParameterMap());
		 LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

		 // Step.2 获取导出数据
		 List<XhOutOrderDeliveryItem> pageList = xhOutOrderDeliveryItemService.list(queryWrapper);
		 List<XhOutOrderDeliveryItem> exportList = null;

		 // 过滤选中数据
		 String selections = request.getParameter("selections");
		 if (oConvertUtils.isNotEmpty(selections)) {
			 List<String> selectionList = Arrays.asList(selections.split(","));
			 exportList = pageList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
		 } else {
			 exportList = pageList;
		 }

		 // Step.3 AutoPoi 导出Excel
		 ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
		 //此处设置的filename无效,前端会重更新设置一下
		 mv.addObject(NormalExcelConstants.FILE_NAME, "鑫宏配送单明细");
		 mv.addObject(NormalExcelConstants.CLASS, XhOutOrderDeliveryItem.class);
		 mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("鑫宏配送单明细报表", "导出人:" + sysUser.getRealname(), "鑫宏配送单明细"));
		 mv.addObject(NormalExcelConstants.DATA_LIST, exportList);
		 return mv;
    }

    /**
     * 导入
     * @return
     */
    @RequestMapping(value = "/importXhOutOrderDeliveryItem/{mainId}")
    public Result<?> importXhOutOrderDeliveryItem(HttpServletRequest request, HttpServletResponse response, @PathVariable("mainId") String mainId) {
		 MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		 Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		 for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
       // 获取上传文件对象
			 MultipartFile file = entity.getValue();
			 ImportParams params = new ImportParams();
			 params.setTitleRows(2);
			 params.setHeadRows(1);
			 params.setNeedSave(true);
			 try {
				 List<XhOutOrderDeliveryItem> list = ExcelImportUtil.importExcel(file.getInputStream(), XhOutOrderDeliveryItem.class, params);
				 for (XhOutOrderDeliveryItem temp : list) {
                    temp.setOrderNo(mainId);
				 }
				 long start = System.currentTimeMillis();
				 xhOutOrderDeliveryItemService.saveBatch(list);
				 log.info("消耗时间" + (System.currentTimeMillis() - start) + "毫秒");
				 return Result.OK("文件导入成功！数据行数：" + list.size());
			 } catch (Exception e) {
				 log.error(e.getMessage(), e);
				 return Result.error("文件导入失败:" + e.getMessage());
			 } finally {
				 try {
					 file.getInputStream().close();
				 } catch (IOException e) {
					 e.printStackTrace();
				 }
			 }
		 }
		 return Result.error("文件导入失败！");
    }

    /*--------------------------------子表处理-鑫宏配送单明细-end----------------------------------------------*/




}
