package org.jeecg.modules.wms.controller;

import org.jeecg.common.system.query.QueryGenerator;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.api.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import java.util.Arrays;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.XhOutOrderItem;
import org.jeecg.modules.wms.entity.XhOutOrder;
import org.jeecg.modules.wms.service.IXhOutOrderService;
import org.jeecg.modules.wms.service.IXhOutOrderItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 鑫泓出库单
 * @Author: jeecg-boot
 * @Date:   2024-11-10
 * @Version: V1.0
 */
@Api(tags="鑫泓出库单")
@RestController
@RequestMapping("/wms/xhOutOrder")
@Slf4j
public class XhOutOrderController extends JeecgController<XhOutOrder, IXhOutOrderService> {

	@Autowired
	private IXhOutOrderService xhOutOrderService;

	@Autowired
	private IXhOutOrderItemService xhOutOrderItemService;


	/*---------------------------------主表处理-begin-------------------------------------*/

	/**
	 * 分页列表查询
	 * @param xhOutOrder
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "鑫泓出库单-分页列表查询")
	@ApiOperation(value="鑫泓出库单-分页列表查询", notes="鑫泓出库单-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<XhOutOrder>> queryPageList(XhOutOrder xhOutOrder,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<XhOutOrder> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrder, req.getParameterMap());
		Page<XhOutOrder> page = new Page<XhOutOrder>(pageNo, pageSize);
		IPage<XhOutOrder> pageList = xhOutOrderService.page(page, queryWrapper);
		return Result.OK(pageList);
	}

	/**
     *   添加
     * @param xhOutOrder
     * @return
     */
    @AutoLog(value = "鑫泓出库单-添加")
    @ApiOperation(value="鑫泓出库单-添加", notes="鑫泓出库单-添加")
    @RequiresPermissions("wms:xh_out_order:add")
    @PostMapping(value = "/add")
    public Result<String> add(@RequestBody XhOutOrder xhOutOrder) {
        xhOutOrderService.save(xhOutOrder);
        return Result.OK("添加成功！");
    }

    /**
     *  编辑
     * @param xhOutOrder
     * @return
     */
    @AutoLog(value = "鑫泓出库单-编辑")
    @ApiOperation(value="鑫泓出库单-编辑", notes="鑫泓出库单-编辑")
    @RequiresPermissions("wms:xh_out_order:edit")
    @RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
    public Result<String> edit(@RequestBody XhOutOrder xhOutOrder) {
        xhOutOrderService.updateById(xhOutOrder);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     * @param id
     * @return
     */
    @AutoLog(value = "鑫泓出库单-通过id删除")
    @ApiOperation(value="鑫泓出库单-通过id删除", notes="鑫泓出库单-通过id删除")
    @RequiresPermissions("wms:xh_out_order:delete")
    @DeleteMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name="id",required=true) String id) {
        xhOutOrderService.delMain(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @AutoLog(value = "鑫泓出库单-批量删除")
    @ApiOperation(value="鑫泓出库单-批量删除", notes="鑫泓出库单-批量删除")
    @RequiresPermissions("wms:xh_out_order:deleteBatch")
    @DeleteMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
        this.xhOutOrderService.delBatchMain(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 导出
     * @return
     */
    @RequiresPermissions("wms:xh_out_order:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, XhOutOrder xhOutOrder) {
        return super.exportXls(request, xhOutOrder, XhOutOrder.class, "鑫泓出库单");
    }

    /**
     * 导入
     * @return
     */
    @RequiresPermissions("wms:xh_out_order:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, XhOutOrder.class);
    }
	/*---------------------------------主表处理-end-------------------------------------*/
	

    /*--------------------------------子表处理-鑫泓出库单明细-begin----------------------------------------------*/
	/**
	 * 通过主表ID查询
	 * @return
	 */
	//@AutoLog(value = "鑫泓出库单明细-通过主表ID查询")
	@ApiOperation(value="鑫泓出库单明细-通过主表ID查询", notes="鑫泓出库单明细-通过主表ID查询")
	@GetMapping(value = "/listXhOutOrderItemByMainId")
    public Result<IPage<XhOutOrderItem>> listXhOutOrderItemByMainId(XhOutOrderItem xhOutOrderItem,
                                                    @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                    @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                    HttpServletRequest req) {
        QueryWrapper<XhOutOrderItem> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderItem, req.getParameterMap());
        Page<XhOutOrderItem> page = new Page<XhOutOrderItem>(pageNo, pageSize);
        IPage<XhOutOrderItem> pageList = xhOutOrderItemService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

	/**
	 * 添加
	 * @param xhOutOrderItem
	 * @return
	 */
	@AutoLog(value = "鑫泓出库单明细-添加")
	@ApiOperation(value="鑫泓出库单明细-添加", notes="鑫泓出库单明细-添加")
	@PostMapping(value = "/addXhOutOrderItem")
	public Result<String> addXhOutOrderItem(@RequestBody XhOutOrderItem xhOutOrderItem) {
		xhOutOrderItemService.save(xhOutOrderItem);
		return Result.OK("添加成功！");
	}

    /**
	 * 编辑
	 * @param xhOutOrderItem
	 * @return
	 */
	@AutoLog(value = "鑫泓出库单明细-编辑")
	@ApiOperation(value="鑫泓出库单明细-编辑", notes="鑫泓出库单明细-编辑")
	@RequestMapping(value = "/editXhOutOrderItem", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> editXhOutOrderItem(@RequestBody XhOutOrderItem xhOutOrderItem) {
		xhOutOrderItemService.updateById(xhOutOrderItem);
		return Result.OK("编辑成功!");
	}

	/**
	 * 通过id删除
	 * @param id
	 * @return
	 */
	@AutoLog(value = "鑫泓出库单明细-通过id删除")
	@ApiOperation(value="鑫泓出库单明细-通过id删除", notes="鑫泓出库单明细-通过id删除")
	@DeleteMapping(value = "/deleteXhOutOrderItem")
	public Result<String> deleteXhOutOrderItem(@RequestParam(name="id",required=true) String id) {
		xhOutOrderItemService.removeById(id);
		return Result.OK("删除成功!");
	}

	/**
	 * 批量删除
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "鑫泓出库单明细-批量删除")
	@ApiOperation(value="鑫泓出库单明细-批量删除", notes="鑫泓出库单明细-批量删除")
	@DeleteMapping(value = "/deleteBatchXhOutOrderItem")
	public Result<String> deleteBatchXhOutOrderItem(@RequestParam(name="ids",required=true) String ids) {
	    this.xhOutOrderItemService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}

    /**
     * 导出
     * @return
     */
    @RequestMapping(value = "/exportXhOutOrderItem")
    public ModelAndView exportXhOutOrderItem(HttpServletRequest request, XhOutOrderItem xhOutOrderItem) {
		 // Step.1 组装查询条件
		 QueryWrapper<XhOutOrderItem> queryWrapper = QueryGenerator.initQueryWrapper(xhOutOrderItem, request.getParameterMap());
		 LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

		 // Step.2 获取导出数据
		 List<XhOutOrderItem> pageList = xhOutOrderItemService.list(queryWrapper);
		 List<XhOutOrderItem> exportList = null;

		 // 过滤选中数据
		 String selections = request.getParameter("selections");
		 if (oConvertUtils.isNotEmpty(selections)) {
			 List<String> selectionList = Arrays.asList(selections.split(","));
			 exportList = pageList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
		 } else {
			 exportList = pageList;
		 }

		 // Step.3 AutoPoi 导出Excel
		 ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
		 //此处设置的filename无效,前端会重更新设置一下
		 mv.addObject(NormalExcelConstants.FILE_NAME, "鑫泓出库单明细");
		 mv.addObject(NormalExcelConstants.CLASS, XhOutOrderItem.class);
		 mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("鑫泓出库单明细报表", "导出人:" + sysUser.getRealname(), "鑫泓出库单明细"));
		 mv.addObject(NormalExcelConstants.DATA_LIST, exportList);
		 return mv;
    }

    /**
     * 导入
     * @return
     */
    @RequestMapping(value = "/importXhOutOrderItem/{mainId}")
    public Result<?> importXhOutOrderItem(HttpServletRequest request, HttpServletResponse response, @PathVariable("mainId") Integer mainId) {
		 MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		 Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		 for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
       // 获取上传文件对象
			 MultipartFile file = entity.getValue();
			 ImportParams params = new ImportParams();
			 params.setTitleRows(2);
			 params.setHeadRows(1);
			 params.setNeedSave(true);
			 try {
				 List<XhOutOrderItem> list = ExcelImportUtil.importExcel(file.getInputStream(), XhOutOrderItem.class, params);
				 for (XhOutOrderItem temp : list) {
                    temp.setOrderId(mainId);
				 }
				 long start = System.currentTimeMillis();
				 xhOutOrderItemService.saveBatch(list);
				 log.info("消耗时间" + (System.currentTimeMillis() - start) + "毫秒");
				 return Result.OK("文件导入成功！数据行数：" + list.size());
			 } catch (Exception e) {
				 log.error(e.getMessage(), e);
				 return Result.error("文件导入失败:" + e.getMessage());
			 } finally {
				 try {
					 file.getInputStream().close();
				 } catch (IOException e) {
					 e.printStackTrace();
				 }
			 }
		 }
		 return Result.error("文件导入失败！");
    }

    /*--------------------------------子表处理-鑫泓出库单明细-end----------------------------------------------*/




}
