package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.XhGoodsPushError;
import org.jeecg.modules.wms.service.IXhGoodsPushErrorService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 物料推送失败记录
 * @Author: jeecg-boot
 * @Date:   2024-08-28
 * @Version: V1.0
 */
@Api(tags="物料推送失败记录")
@RestController
@RequestMapping("/wms/xhGoodsPushError")
@Slf4j
public class XhGoodsPushErrorController extends JeecgController<XhGoodsPushError, IXhGoodsPushErrorService> {
	@Autowired
	private IXhGoodsPushErrorService xhGoodsPushErrorService;
	
	/**
	 * 分页列表查询
	 *
	 * @param xhGoodsPushError
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "物料推送失败记录-分页列表查询")
	@ApiOperation(value="物料推送失败记录-分页列表查询", notes="物料推送失败记录-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<XhGoodsPushError>> queryPageList(XhGoodsPushError xhGoodsPushError,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<XhGoodsPushError> queryWrapper = QueryGenerator.initQueryWrapper(xhGoodsPushError, req.getParameterMap());
		Page<XhGoodsPushError> page = new Page<XhGoodsPushError>(pageNo, pageSize);
		IPage<XhGoodsPushError> pageList = xhGoodsPushErrorService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param xhGoodsPushError
	 * @return
	 */
	@AutoLog(value = "物料推送失败记录-添加")
	@ApiOperation(value="物料推送失败记录-添加", notes="物料推送失败记录-添加")
	@RequiresPermissions("wms:xh_goods_push_error:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody XhGoodsPushError xhGoodsPushError) {
		xhGoodsPushErrorService.save(xhGoodsPushError);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param xhGoodsPushError
	 * @return
	 */
	@AutoLog(value = "物料推送失败记录-编辑")
	@ApiOperation(value="物料推送失败记录-编辑", notes="物料推送失败记录-编辑")
	@RequiresPermissions("wms:xh_goods_push_error:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody XhGoodsPushError xhGoodsPushError) {
		xhGoodsPushErrorService.updateById(xhGoodsPushError);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "物料推送失败记录-通过id删除")
	@ApiOperation(value="物料推送失败记录-通过id删除", notes="物料推送失败记录-通过id删除")
	@RequiresPermissions("wms:xh_goods_push_error:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		xhGoodsPushErrorService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "物料推送失败记录-批量删除")
	@ApiOperation(value="物料推送失败记录-批量删除", notes="物料推送失败记录-批量删除")
	@RequiresPermissions("wms:xh_goods_push_error:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.xhGoodsPushErrorService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "物料推送失败记录-通过id查询")
	@ApiOperation(value="物料推送失败记录-通过id查询", notes="物料推送失败记录-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<XhGoodsPushError> queryById(@RequestParam(name="id",required=true) String id) {
		XhGoodsPushError xhGoodsPushError = xhGoodsPushErrorService.getById(id);
		if(xhGoodsPushError==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(xhGoodsPushError);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param xhGoodsPushError
    */
    @RequiresPermissions("wms:xh_goods_push_error:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, XhGoodsPushError xhGoodsPushError) {
        return super.exportXls(request, xhGoodsPushError, XhGoodsPushError.class, "物料推送失败记录");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:xh_goods_push_error:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, XhGoodsPushError.class);
    }

}
