package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.WmsWare;
import org.jeecg.modules.wms.service.IWmsWareService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 仓库管理
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@Api(tags="仓库管理")
@RestController
@RequestMapping("/wms/wmsWare")
@Slf4j
public class WmsWareController extends JeecgController<WmsWare, IWmsWareService> {
	@Autowired
	private IWmsWareService wmsWareService;
	
	/**
	 * 分页列表查询
	 *
	 * @param wmsWare
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "仓库管理-分页列表查询")
	@ApiOperation(value="仓库管理-分页列表查询", notes="仓库管理-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<WmsWare>> queryPageList(WmsWare wmsWare,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<WmsWare> queryWrapper = QueryGenerator.initQueryWrapper(wmsWare, req.getParameterMap());
		Page<WmsWare> page = new Page<WmsWare>(pageNo, pageSize);
		IPage<WmsWare> pageList = wmsWareService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param wmsWare
	 * @return
	 */
	@AutoLog(value = "仓库管理-添加")
	@ApiOperation(value="仓库管理-添加", notes="仓库管理-添加")
	@RequiresPermissions("wms:wms_ware:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody WmsWare wmsWare) {
		wmsWareService.save(wmsWare);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param wmsWare
	 * @return
	 */
	@AutoLog(value = "仓库管理-编辑")
	@ApiOperation(value="仓库管理-编辑", notes="仓库管理-编辑")
	@RequiresPermissions("wms:wms_ware:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody WmsWare wmsWare) {
		wmsWareService.updateById(wmsWare);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "仓库管理-通过id删除")
	@ApiOperation(value="仓库管理-通过id删除", notes="仓库管理-通过id删除")
	@RequiresPermissions("wms:wms_ware:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		wmsWareService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "仓库管理-批量删除")
	@ApiOperation(value="仓库管理-批量删除", notes="仓库管理-批量删除")
	@RequiresPermissions("wms:wms_ware:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.wmsWareService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "仓库管理-通过id查询")
	@ApiOperation(value="仓库管理-通过id查询", notes="仓库管理-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<WmsWare> queryById(@RequestParam(name="id",required=true) String id) {
		WmsWare wmsWare = wmsWareService.getById(id);
		if(wmsWare==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(wmsWare);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param wmsWare
    */
    @RequiresPermissions("wms:wms_ware:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsWare wmsWare) {
        return super.exportXls(request, wmsWare, WmsWare.class, "仓库管理");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:wms_ware:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, WmsWare.class);
    }

}
