package org.jeecg.modules.wms.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.pad.api.WmsApi;
import org.jeecg.modules.pad.api.bean.req.TaskUpdateReq;
import org.jeecg.modules.wms.entity.WmsTaskItem;
import org.jeecg.modules.wms.service.IWmsTaskItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * @Description: 任务子项
 * @Author: jeecg-boot
 * @Date: 2024-09-02
 * @Version: V1.0
 */
@Api(tags = "任务子项")
@RestController
@RequestMapping("/wms/wmsTaskItem")
@Slf4j
public class WmsTaskItemController extends JeecgController<WmsTaskItem, IWmsTaskItemService> {
    @Autowired
    private IWmsTaskItemService wmsTaskItemService;
    @Resource
    private WmsApi wmsApi;

    /**
     * 分页列表查询
     *
     * @param wmsTaskItem
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    //@AutoLog(value = "任务子项-分页列表查询")
    @ApiOperation(value = "任务子项-分页列表查询", notes = "任务子项-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<WmsTaskItem>> queryPageList(WmsTaskItem wmsTaskItem,
                                                    @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                    @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                    HttpServletRequest req) {
        QueryWrapper<WmsTaskItem> queryWrapper = QueryGenerator.initQueryWrapper(wmsTaskItem, req.getParameterMap());
        Page<WmsTaskItem> page = new Page<WmsTaskItem>(pageNo, pageSize);
        IPage<WmsTaskItem> pageList = wmsTaskItemService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param wmsTaskItem
     * @return
     */
    @AutoLog(value = "任务子项-添加")
    @ApiOperation(value = "任务子项-添加", notes = "任务子项-添加")
    @RequiresPermissions("wms:wms_task_item:add")
    @PostMapping(value = "/add")
    public Result<String> add(@RequestBody WmsTaskItem wmsTaskItem) {
        wmsTaskItemService.save(wmsTaskItem);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param wmsTaskItem
     * @return
     */
    @AutoLog(value = "任务子项-编辑")
    @ApiOperation(value = "任务子项-编辑", notes = "任务子项-编辑")
    @RequiresPermissions("wms:wms_task_item:edit")
    @RequestMapping(value = "/edit", method = {RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody WmsTaskItem wmsTaskItem) {
        wmsTaskItemService.updateById(wmsTaskItem);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "任务子项-通过id删除")
    @ApiOperation(value = "任务子项-通过id删除", notes = "任务子项-通过id删除")
    @RequiresPermissions("wms:wms_task_item:delete")
    @DeleteMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name = "id", required = true) String id) {
        wmsTaskItemService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "任务子项-批量删除")
    @ApiOperation(value = "任务子项-批量删除", notes = "任务子项-批量删除")
    @RequiresPermissions("wms:wms_task_item:deleteBatch")
    @DeleteMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.wmsTaskItemService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    //@AutoLog(value = "任务子项-通过id查询")
    @ApiOperation(value = "任务子项-通过id查询", notes = "任务子项-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<WmsTaskItem> queryById(@RequestParam(name = "id", required = true) String id) {
        WmsTaskItem wmsTaskItem = wmsTaskItemService.getById(id);
        if (wmsTaskItem == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(wmsTaskItem);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param wmsTaskItem
     */
    @RequiresPermissions("wms:wms_task_item:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsTaskItem wmsTaskItem) {
        return super.exportXls(request, wmsTaskItem, WmsTaskItem.class, "任务子项");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequiresPermissions("wms:wms_task_item:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, WmsTaskItem.class);
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "任务子项-通过id重新下发任务")
    @ApiOperation(value = "任务子项-通过id重新下发任务", notes = "任务子项-通过id重新下发任务")
    @RequiresPermissions("wms:wms_task_item:delete")
    @DeleteMapping(value = "/taskRetry")
    public Result<String> taskRetry(@RequestParam(name = "id", required = true) String id) {
        TaskUpdateReq req = new TaskUpdateReq();
        req.setTaskId(id);
        wmsApi.retryTaskToWcs(req);
        return Result.OK("下发成功!");
    }

    /**
     * 通过id手工取消
     *
     * @param id
     * @return
     */
    @AutoLog(value = "任务子项-通过id手工取消")
    @ApiOperation(value = "任务子项-通过id手工取消", notes = "任务子项-通过id手工取消")
    @RequiresPermissions("wms:wms_task_item:delete")
    @DeleteMapping(value = "/manualCancel")
    public Result<String> manualCancel(@RequestParam(name = "id", required = true) String id) {
        TaskUpdateReq req = new TaskUpdateReq();
        req.setTaskId(id);
        req.setTaskStatus("CANCEL");
        wmsApi.updateTaskStatus(req);
        return Result.OK("下发成功!");
    }

    /**
     * 通过id手工完成
     *
     * @param id
     * @return
     */
    @AutoLog(value = "任务子项-通过id手工完成")
    @ApiOperation(value = "任务子项-通过id手工完成", notes = "任务子项-通过id手工完成")
    @RequiresPermissions("wms:wms_task_item:delete")
    @DeleteMapping(value = "/manualFinish")
    public Result<String> manualFinish(@RequestParam(name = "id", required = true) String id) {
        TaskUpdateReq req = new TaskUpdateReq();
        req.setTaskId(id);
        req.setTaskStatus("FINISH");
        wmsApi.updateTaskStatus(req);
        return Result.OK("下发成功!");
    }

}
