package org.jeecg.modules.wms.controller;

import org.jeecg.common.system.query.QueryGenerator;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.api.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import java.util.Arrays;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.WmsTaskItem;
import org.jeecg.modules.wms.entity.WmsTask;
import org.jeecg.modules.wms.service.IWmsTaskService;
import org.jeecg.modules.wms.service.IWmsTaskItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 任务
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@Api(tags="任务")
@RestController
@RequestMapping("/wms/wmsTask")
@Slf4j
public class WmsTaskController extends JeecgController<WmsTask, IWmsTaskService> {

	@Autowired
	private IWmsTaskService wmsTaskService;

	@Autowired
	private IWmsTaskItemService wmsTaskItemService;


	/*---------------------------------主表处理-begin-------------------------------------*/

	/**
	 * 分页列表查询
	 * @param wmsTask
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "任务-分页列表查询")
	@ApiOperation(value="任务-分页列表查询", notes="任务-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<WmsTask>> queryPageList(WmsTask wmsTask,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<WmsTask> queryWrapper = QueryGenerator.initQueryWrapper(wmsTask, req.getParameterMap());
		Page<WmsTask> page = new Page<WmsTask>(pageNo, pageSize);
		IPage<WmsTask> pageList = wmsTaskService.page(page, queryWrapper);
		return Result.OK(pageList);
	}

	/**
     *   添加
     * @param wmsTask
     * @return
     */
    @AutoLog(value = "任务-添加")
    @ApiOperation(value="任务-添加", notes="任务-添加")
    @RequiresPermissions("wms:wms_task:add")
    @PostMapping(value = "/add")
    public Result<String> add(@RequestBody WmsTask wmsTask) {
        wmsTaskService.save(wmsTask);
        return Result.OK("添加成功！");
    }

    /**
     *  编辑
     * @param wmsTask
     * @return
     */
    @AutoLog(value = "任务-编辑")
    @ApiOperation(value="任务-编辑", notes="任务-编辑")
    @RequiresPermissions("wms:wms_task:edit")
    @RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
    public Result<String> edit(@RequestBody WmsTask wmsTask) {
        wmsTaskService.updateById(wmsTask);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     * @param id
     * @return
     */
    @AutoLog(value = "任务-通过id删除")
    @ApiOperation(value="任务-通过id删除", notes="任务-通过id删除")
    @RequiresPermissions("wms:wms_task:delete")
    @DeleteMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name="id",required=true) String id) {
        wmsTaskService.delMain(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @AutoLog(value = "任务-批量删除")
    @ApiOperation(value="任务-批量删除", notes="任务-批量删除")
    @RequiresPermissions("wms:wms_task:deleteBatch")
    @DeleteMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
        this.wmsTaskService.delBatchMain(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 导出
     * @return
     */
    @RequiresPermissions("wms:wms_task:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsTask wmsTask) {
        return super.exportXls(request, wmsTask, WmsTask.class, "任务");
    }

    /**
     * 导入
     * @return
     */
    @RequiresPermissions("wms:wms_task:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, WmsTask.class);
    }
	/*---------------------------------主表处理-end-------------------------------------*/
	

    /*--------------------------------子表处理-任务子项-begin----------------------------------------------*/
	/**
	 * 通过主表ID查询
	 * @return
	 */
	//@AutoLog(value = "任务子项-通过主表ID查询")
	@ApiOperation(value="任务子项-通过主表ID查询", notes="任务子项-通过主表ID查询")
	@GetMapping(value = "/listWmsTaskItemByMainId")
    public Result<IPage<WmsTaskItem>> listWmsTaskItemByMainId(WmsTaskItem wmsTaskItem,
                                                    @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                    @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                    HttpServletRequest req) {
        QueryWrapper<WmsTaskItem> queryWrapper = QueryGenerator.initQueryWrapper(wmsTaskItem, req.getParameterMap());
        Page<WmsTaskItem> page = new Page<WmsTaskItem>(pageNo, pageSize);
        IPage<WmsTaskItem> pageList = wmsTaskItemService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

	/**
	 * 添加
	 * @param wmsTaskItem
	 * @return
	 */
	@AutoLog(value = "任务子项-添加")
	@ApiOperation(value="任务子项-添加", notes="任务子项-添加")
	@PostMapping(value = "/addWmsTaskItem")
	public Result<String> addWmsTaskItem(@RequestBody WmsTaskItem wmsTaskItem) {
		wmsTaskItemService.save(wmsTaskItem);
		return Result.OK("添加成功！");
	}

    /**
	 * 编辑
	 * @param wmsTaskItem
	 * @return
	 */
	@AutoLog(value = "任务子项-编辑")
	@ApiOperation(value="任务子项-编辑", notes="任务子项-编辑")
	@RequestMapping(value = "/editWmsTaskItem", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> editWmsTaskItem(@RequestBody WmsTaskItem wmsTaskItem) {
		wmsTaskItemService.updateById(wmsTaskItem);
		return Result.OK("编辑成功!");
	}

	/**
	 * 通过id删除
	 * @param id
	 * @return
	 */
	@AutoLog(value = "任务子项-通过id删除")
	@ApiOperation(value="任务子项-通过id删除", notes="任务子项-通过id删除")
	@DeleteMapping(value = "/deleteWmsTaskItem")
	public Result<String> deleteWmsTaskItem(@RequestParam(name="id",required=true) String id) {
		wmsTaskItemService.removeById(id);
		return Result.OK("删除成功!");
	}

	/**
	 * 批量删除
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "任务子项-批量删除")
	@ApiOperation(value="任务子项-批量删除", notes="任务子项-批量删除")
	@DeleteMapping(value = "/deleteBatchWmsTaskItem")
	public Result<String> deleteBatchWmsTaskItem(@RequestParam(name="ids",required=true) String ids) {
	    this.wmsTaskItemService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}

    /**
     * 导出
     * @return
     */
    @RequestMapping(value = "/exportWmsTaskItem")
    public ModelAndView exportWmsTaskItem(HttpServletRequest request, WmsTaskItem wmsTaskItem) {
		 // Step.1 组装查询条件
		 QueryWrapper<WmsTaskItem> queryWrapper = QueryGenerator.initQueryWrapper(wmsTaskItem, request.getParameterMap());
		 LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

		 // Step.2 获取导出数据
		 List<WmsTaskItem> pageList = wmsTaskItemService.list(queryWrapper);
		 List<WmsTaskItem> exportList = null;

		 // 过滤选中数据
		 String selections = request.getParameter("selections");
		 if (oConvertUtils.isNotEmpty(selections)) {
			 List<String> selectionList = Arrays.asList(selections.split(","));
			 exportList = pageList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
		 } else {
			 exportList = pageList;
		 }

		 // Step.3 AutoPoi 导出Excel
		 ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
		 //此处设置的filename无效,前端会重更新设置一下
		 mv.addObject(NormalExcelConstants.FILE_NAME, "任务子项");
		 mv.addObject(NormalExcelConstants.CLASS, WmsTaskItem.class);
		 mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("任务子项报表", "导出人:" + sysUser.getRealname(), "任务子项"));
		 mv.addObject(NormalExcelConstants.DATA_LIST, exportList);
		 return mv;
    }

    /**
     * 导入
     * @return
     */
    @RequestMapping(value = "/importWmsTaskItem/{mainId}")
    public Result<?> importWmsTaskItem(HttpServletRequest request, HttpServletResponse response, @PathVariable("mainId") int mainId) {
		 MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		 Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		 for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
       // 获取上传文件对象
			 MultipartFile file = entity.getValue();
			 ImportParams params = new ImportParams();
			 params.setTitleRows(2);
			 params.setHeadRows(1);
			 params.setNeedSave(true);
			 try {
				 List<WmsTaskItem> list = ExcelImportUtil.importExcel(file.getInputStream(), WmsTaskItem.class, params);
				 for (WmsTaskItem temp : list) {
                    temp.setTaskId(mainId);
				 }
				 long start = System.currentTimeMillis();
				 wmsTaskItemService.saveBatch(list);
				 log.info("消耗时间" + (System.currentTimeMillis() - start) + "毫秒");
				 return Result.OK("文件导入成功！数据行数：" + list.size());
			 } catch (Exception e) {
				 log.error(e.getMessage(), e);
				 return Result.error("文件导入失败:" + e.getMessage());
			 } finally {
				 try {
					 file.getInputStream().close();
				 } catch (IOException e) {
					 e.printStackTrace();
				 }
			 }
		 }
		 return Result.error("文件导入失败！");
    }

    /*--------------------------------子表处理-任务子项-end----------------------------------------------*/




}
