package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.WmsStation;
import org.jeecg.modules.wms.service.IWmsStationService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 工作站
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@Api(tags="工作站")
@RestController
@RequestMapping("/wms/wmsStation")
@Slf4j
public class WmsStationController extends JeecgController<WmsStation, IWmsStationService> {
	@Autowired
	private IWmsStationService wmsStationService;
	
	/**
	 * 分页列表查询
	 *
	 * @param wmsStation
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "工作站-分页列表查询")
	@ApiOperation(value="工作站-分页列表查询", notes="工作站-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<WmsStation>> queryPageList(WmsStation wmsStation,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<WmsStation> queryWrapper = QueryGenerator.initQueryWrapper(wmsStation, req.getParameterMap());
		Page<WmsStation> page = new Page<WmsStation>(pageNo, pageSize);
		IPage<WmsStation> pageList = wmsStationService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param wmsStation
	 * @return
	 */
	@AutoLog(value = "工作站-添加")
	@ApiOperation(value="工作站-添加", notes="工作站-添加")
	@RequiresPermissions("wms:wms_station:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody WmsStation wmsStation) {
		wmsStationService.save(wmsStation);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param wmsStation
	 * @return
	 */
	@AutoLog(value = "工作站-编辑")
	@ApiOperation(value="工作站-编辑", notes="工作站-编辑")
	@RequiresPermissions("wms:wms_station:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody WmsStation wmsStation) {
		wmsStationService.updateById(wmsStation);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "工作站-通过id删除")
	@ApiOperation(value="工作站-通过id删除", notes="工作站-通过id删除")
	@RequiresPermissions("wms:wms_station:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		wmsStationService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "工作站-批量删除")
	@ApiOperation(value="工作站-批量删除", notes="工作站-批量删除")
	@RequiresPermissions("wms:wms_station:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.wmsStationService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "工作站-通过id查询")
	@ApiOperation(value="工作站-通过id查询", notes="工作站-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<WmsStation> queryById(@RequestParam(name="id",required=true) String id) {
		WmsStation wmsStation = wmsStationService.getById(id);
		if(wmsStation==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(wmsStation);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param wmsStation
    */
    @RequiresPermissions("wms:wms_station:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsStation wmsStation) {
        return super.exportXls(request, wmsStation, WmsStation.class, "工作站");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:wms_station:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, WmsStation.class);
    }

}
