package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.WmsSoItem;
import org.jeecg.modules.wms.service.IWmsSoItemService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 出库单子项
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@Api(tags="出库单子项")
@RestController
@RequestMapping("/wms/wmsSoItem")
@Slf4j
public class WmsSoItemController extends JeecgController<WmsSoItem, IWmsSoItemService> {
	@Autowired
	private IWmsSoItemService wmsSoItemService;
	
	/**
	 * 分页列表查询
	 *
	 * @param wmsSoItem
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "出库单子项-分页列表查询")
	@ApiOperation(value="出库单子项-分页列表查询", notes="出库单子项-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<WmsSoItem>> queryPageList(WmsSoItem wmsSoItem,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<WmsSoItem> queryWrapper = QueryGenerator.initQueryWrapper(wmsSoItem, req.getParameterMap());
		Page<WmsSoItem> page = new Page<WmsSoItem>(pageNo, pageSize);
		IPage<WmsSoItem> pageList = wmsSoItemService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param wmsSoItem
	 * @return
	 */
	@AutoLog(value = "出库单子项-添加")
	@ApiOperation(value="出库单子项-添加", notes="出库单子项-添加")
	@RequiresPermissions("wms:wms_so_item:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody WmsSoItem wmsSoItem) {
		wmsSoItemService.save(wmsSoItem);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param wmsSoItem
	 * @return
	 */
	@AutoLog(value = "出库单子项-编辑")
	@ApiOperation(value="出库单子项-编辑", notes="出库单子项-编辑")
	@RequiresPermissions("wms:wms_so_item:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody WmsSoItem wmsSoItem) {
		wmsSoItemService.updateById(wmsSoItem);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "出库单子项-通过id删除")
	@ApiOperation(value="出库单子项-通过id删除", notes="出库单子项-通过id删除")
	@RequiresPermissions("wms:wms_so_item:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		wmsSoItemService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "出库单子项-批量删除")
	@ApiOperation(value="出库单子项-批量删除", notes="出库单子项-批量删除")
	@RequiresPermissions("wms:wms_so_item:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.wmsSoItemService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "出库单子项-通过id查询")
	@ApiOperation(value="出库单子项-通过id查询", notes="出库单子项-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<WmsSoItem> queryById(@RequestParam(name="id",required=true) String id) {
		WmsSoItem wmsSoItem = wmsSoItemService.getById(id);
		if(wmsSoItem==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(wmsSoItem);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param wmsSoItem
    */
    @RequiresPermissions("wms:wms_so_item:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsSoItem wmsSoItem) {
        return super.exportXls(request, wmsSoItem, WmsSoItem.class, "出库单子项");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:wms_so_item:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, WmsSoItem.class);
    }

}
