package org.jeecg.modules.wms.controller;

import java.io.UnsupportedEncodingException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.WmsSoItem;
import org.jeecg.modules.wms.entity.WmsSo;
import org.jeecg.modules.wms.vo.WmsSoPage;
import org.jeecg.modules.wms.service.IWmsSoService;
import org.jeecg.modules.wms.service.IWmsSoItemService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 出库单
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@Api(tags="出库单")
@RestController
@RequestMapping("/wms/wmsSo")
@Slf4j
public class WmsSoController {
	@Autowired
	private IWmsSoService wmsSoService;
	@Autowired
	private IWmsSoItemService wmsSoItemService;
	
	/**
	 * 分页列表查询
	 *
	 * @param wmsSo
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "出库单-分页列表查询")
	@ApiOperation(value="出库单-分页列表查询", notes="出库单-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<WmsSo>> queryPageList(WmsSo wmsSo,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<WmsSo> queryWrapper = QueryGenerator.initQueryWrapper(wmsSo, req.getParameterMap());
		Page<WmsSo> page = new Page<WmsSo>(pageNo, pageSize);
		IPage<WmsSo> pageList = wmsSoService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param wmsSoPage
	 * @return
	 */
	@AutoLog(value = "出库单-添加")
	@ApiOperation(value="出库单-添加", notes="出库单-添加")
    @RequiresPermissions("wms:wms_so:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody WmsSoPage wmsSoPage) {
		WmsSo wmsSo = new WmsSo();
		BeanUtils.copyProperties(wmsSoPage, wmsSo);
		wmsSoService.saveMain(wmsSo, wmsSoPage.getWmsSoItemList());
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param wmsSoPage
	 * @return
	 */
	@AutoLog(value = "出库单-编辑")
	@ApiOperation(value="出库单-编辑", notes="出库单-编辑")
    @RequiresPermissions("wms:wms_so:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody WmsSoPage wmsSoPage) {
		WmsSo wmsSo = new WmsSo();
		BeanUtils.copyProperties(wmsSoPage, wmsSo);
		WmsSo wmsSoEntity = wmsSoService.getById(wmsSo.getId());
		if(wmsSoEntity==null) {
			return Result.error("未找到对应数据");
		}
		wmsSoService.updateMain(wmsSo, wmsSoPage.getWmsSoItemList());
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "出库单-通过id删除")
	@ApiOperation(value="出库单-通过id删除", notes="出库单-通过id删除")
    @RequiresPermissions("wms:wms_so:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		wmsSoService.delMain(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "出库单-批量删除")
	@ApiOperation(value="出库单-批量删除", notes="出库单-批量删除")
    @RequiresPermissions("wms:wms_so:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.wmsSoService.delBatchMain(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "出库单-通过id查询")
	@ApiOperation(value="出库单-通过id查询", notes="出库单-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<WmsSo> queryById(@RequestParam(name="id",required=true) String id) {
		WmsSo wmsSo = wmsSoService.getById(id);
		if(wmsSo==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(wmsSo);

	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "出库单子项-通过主表ID查询")
	@ApiOperation(value="出库单子项-通过主表ID查询", notes="出库单子项-通过主表ID查询")
	@GetMapping(value = "/queryWmsSoItemByMainId")
	public Result<IPage<WmsSoItem>> queryWmsSoItemListByMainId(@RequestParam(name="id",required=true) String id) {
		List<WmsSoItem> wmsSoItemList = wmsSoItemService.selectByMainId(id);
		IPage <WmsSoItem> page = new Page<>();
		page.setRecords(wmsSoItemList);
		page.setTotal(wmsSoItemList.size());
		return Result.OK(page);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param wmsSo
    */
    @RequiresPermissions("wms:wms_so:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsSo wmsSo) {
      // Step.1 组装查询条件查询数据
      QueryWrapper<WmsSo> queryWrapper = QueryGenerator.initQueryWrapper(wmsSo, request.getParameterMap());
      LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

     //配置选中数据查询条件
      String selections = request.getParameter("selections");
      if(oConvertUtils.isNotEmpty(selections)) {
           List<String> selectionList = Arrays.asList(selections.split(","));
           queryWrapper.in("id",selectionList);
      }
      //Step.2 获取导出数据
      List<WmsSo>  wmsSoList = wmsSoService.list(queryWrapper);

      // Step.3 组装pageList
      List<WmsSoPage> pageList = new ArrayList<WmsSoPage>();
      for (WmsSo main : wmsSoList) {
          WmsSoPage vo = new WmsSoPage();
          BeanUtils.copyProperties(main, vo);
          List<WmsSoItem> wmsSoItemList = wmsSoItemService.selectByMainId(main.getOrderNo());
          vo.setWmsSoItemList(wmsSoItemList);
          pageList.add(vo);
      }

      // Step.4 AutoPoi 导出Excel
      ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
      mv.addObject(NormalExcelConstants.FILE_NAME, "出库单列表");
      mv.addObject(NormalExcelConstants.CLASS, WmsSoPage.class);
      mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("出库单数据", "导出人:"+sysUser.getRealname(), "出库单"));
      mv.addObject(NormalExcelConstants.DATA_LIST, pageList);
      return mv;
    }

    /**
    * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:wms_so:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
      MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
      Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
      for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
          // 获取上传文件对象
          MultipartFile file = entity.getValue();
          ImportParams params = new ImportParams();
          params.setTitleRows(2);
          params.setHeadRows(1);
          params.setNeedSave(true);
          try {
              List<WmsSoPage> list = ExcelImportUtil.importExcel(file.getInputStream(), WmsSoPage.class, params);
              for (WmsSoPage page : list) {
                  WmsSo po = new WmsSo();
                  BeanUtils.copyProperties(page, po);
                  wmsSoService.saveMain(po, page.getWmsSoItemList());
              }
              return Result.OK("文件导入成功！数据行数:" + list.size());
          } catch (Exception e) {
              log.error(e.getMessage(),e);
              return Result.error("文件导入失败:"+e.getMessage());
          } finally {
              try {
                  file.getInputStream().close();
              } catch (IOException e) {
                  e.printStackTrace();
              }
          }
      }
      return Result.OK("文件导入失败！");
    }

}
