package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.pad.api.WmsApi;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CreateOutTaskReq;
import org.jeecg.modules.wms.entity.WmsContainer;
import org.jeecg.modules.wms.entity.WmsPallet;
import org.jeecg.modules.wms.service.IWmsPalletService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 托盘管理
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@Api(tags="托盘管理")
@RestController
@RequestMapping("/wms/wmsPallet")
@Slf4j
public class WmsPalletController extends JeecgController<WmsPallet, IWmsPalletService> {
	@Autowired
	private IWmsPalletService wmsPalletService;
	@Resource
	private WmsApi wmsApi;

	 /**
	 * 分页列表查询
	 *
	 * @param wmsPallet
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "托盘管理-分页列表查询")
	@ApiOperation(value="托盘管理-分页列表查询", notes="托盘管理-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<WmsPallet>> queryPageList(WmsPallet wmsPallet,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<WmsPallet> queryWrapper = QueryGenerator.initQueryWrapper(wmsPallet, req.getParameterMap());
		Page<WmsPallet> page = new Page<WmsPallet>(pageNo, pageSize);
		IPage<WmsPallet> pageList = wmsPalletService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param wmsPallet
	 * @return
	 */
	@AutoLog(value = "托盘管理-添加")
	@ApiOperation(value="托盘管理-添加", notes="托盘管理-添加")
	@RequiresPermissions("wms:wms_pallet:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody WmsPallet wmsPallet) {
		wmsPalletService.save(wmsPallet);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param wmsPallet
	 * @return
	 */
	@AutoLog(value = "托盘管理-编辑")
	@ApiOperation(value="托盘管理-编辑", notes="托盘管理-编辑")
	@RequiresPermissions("wms:wms_pallet:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody WmsPallet wmsPallet) {
		wmsPalletService.updateById(wmsPallet);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "托盘管理-通过id删除")
	@ApiOperation(value="托盘管理-通过id删除", notes="托盘管理-通过id删除")
	@RequiresPermissions("wms:wms_pallet:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		wmsPalletService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "托盘管理-批量删除")
	@ApiOperation(value="托盘管理-批量删除", notes="托盘管理-批量删除")
	@RequiresPermissions("wms:wms_pallet:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.wmsPalletService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "托盘管理-通过id查询")
	@ApiOperation(value="托盘管理-通过id查询", notes="托盘管理-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<WmsPallet> queryById(@RequestParam(name="id",required=true) String id) {
		WmsPallet wmsPallet = wmsPalletService.getById(id);
		if(wmsPallet==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(wmsPallet);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param wmsPallet
    */
    @RequiresPermissions("wms:wms_pallet:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsPallet wmsPallet) {
        return super.exportXls(request, wmsPallet, WmsPallet.class, "托盘管理");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:wms_pallet:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, WmsPallet.class);
    }

	 /**
	  * 通过id删除
	  *
	  * @param wmsPallet
	  * @return
	  */
	 @AutoLog(value = "容器货品-通过id取货")
	 @ApiOperation(value = "容器货品-通过id取货", notes = "容器货品-通过id取货")
	 @PostMapping(value = "/takeOutOne")
	 public Result taskOutOne(@RequestBody WmsPallet wmsPallet) {
		 log.info("取货参数: {}", JSON.toJSONString(wmsPallet));
		 //获取货箱
		 CreateOutTaskReq req = new CreateOutTaskReq();
		 req.setBox(wmsPallet.getPalletCode());
		 req.setFromLoc(wmsPallet.getLocCode());
		 req.setToLoc(wmsPallet.getToLocCode());
		 LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
		 req.setUser(sysUser.getUsername());
		 WmsRes res= wmsApi.createOutTask(req);
		 return res.getCode()==200?Result.OK(res.getMsg()):Result.error(res.getMsg());
	 }
}
