package org.jeecg.modules.wms.controller;

import java.io.UnsupportedEncodingException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.WmsStation;
import org.jeecg.modules.wms.entity.WmsLoc;
import org.jeecg.modules.wms.vo.WmsLocPage;
import org.jeecg.modules.wms.service.IWmsLocService;
import org.jeecg.modules.wms.service.IWmsStationService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 库位管理
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@Api(tags="库位管理")
@RestController
@RequestMapping("/wms/wmsLoc")
@Slf4j
public class WmsLocController {
	@Autowired
	private IWmsLocService wmsLocService;
	@Autowired
	private IWmsStationService wmsStationService;
	
	/**
	 * 分页列表查询
	 *
	 * @param wmsLoc
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "库位管理-分页列表查询")
	@ApiOperation(value="库位管理-分页列表查询", notes="库位管理-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<WmsLoc>> queryPageList(WmsLoc wmsLoc,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<WmsLoc> queryWrapper = QueryGenerator.initQueryWrapper(wmsLoc, req.getParameterMap());
		Page<WmsLoc> page = new Page<WmsLoc>(pageNo, pageSize);
		IPage<WmsLoc> pageList = wmsLocService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param wmsLocPage
	 * @return
	 */
	@AutoLog(value = "库位管理-添加")
	@ApiOperation(value="库位管理-添加", notes="库位管理-添加")
    @RequiresPermissions("wms:wms_loc:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody WmsLocPage wmsLocPage) {
		WmsLoc wmsLoc = new WmsLoc();
		BeanUtils.copyProperties(wmsLocPage, wmsLoc);
		wmsLocService.saveMain(wmsLoc, wmsLocPage.getWmsStationList());
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param wmsLocPage
	 * @return
	 */
	@AutoLog(value = "库位管理-编辑")
	@ApiOperation(value="库位管理-编辑", notes="库位管理-编辑")
    @RequiresPermissions("wms:wms_loc:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody WmsLocPage wmsLocPage) {
		WmsLoc wmsLoc = new WmsLoc();
		BeanUtils.copyProperties(wmsLocPage, wmsLoc);
		WmsLoc wmsLocEntity = wmsLocService.getById(wmsLoc.getId());
		if(wmsLocEntity==null) {
			return Result.error("未找到对应数据");
		}
		wmsLocService.updateMain(wmsLoc, wmsLocPage.getWmsStationList());
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过code删除
	 *
	 * @param code
	 * @return
	 */
	@AutoLog(value = "库位管理-通过id删除")
	@ApiOperation(value="库位管理-通过id删除", notes="库位管理-通过id删除")
    @RequiresPermissions("wms:wms_loc:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="code",required=true) String code) {
		wmsLocService.delMain(code);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "库位管理-批量删除")
	@ApiOperation(value="库位管理-批量删除", notes="库位管理-批量删除")
    @RequiresPermissions("wms:wms_loc:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.wmsLocService.delBatchMain(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "库位管理-通过id查询")
	@ApiOperation(value="库位管理-通过id查询", notes="库位管理-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<WmsLoc> queryById(@RequestParam(name="id",required=true) String id) {
		WmsLoc wmsLoc = wmsLocService.getById(id);
		if(wmsLoc==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(wmsLoc);

	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "工作站管理-通过主表ID查询")
	@ApiOperation(value="工作站管理-通过主表ID查询", notes="工作站管理-通过主表ID查询")
	@GetMapping(value = "/queryWmsStationByMainId")
	public Result<IPage<WmsStation>> queryWmsStationListByMainId(@RequestParam(name="code",required=true) String code) {
		List<WmsStation> wmsStationList = wmsStationService.selectByMainCode(code);
		IPage <WmsStation> page = new Page<>();
		page.setRecords(wmsStationList);
		page.setTotal(wmsStationList.size());
		return Result.OK(page);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param wmsLoc
    */
    @RequiresPermissions("wms:wms_loc:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsLoc wmsLoc) {
      // Step.1 组装查询条件查询数据
      QueryWrapper<WmsLoc> queryWrapper = QueryGenerator.initQueryWrapper(wmsLoc, request.getParameterMap());
      LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

     //配置选中数据查询条件
      String selections = request.getParameter("selections");
      if(oConvertUtils.isNotEmpty(selections)) {
           List<String> selectionList = Arrays.asList(selections.split(","));
           queryWrapper.in("code",selectionList);
      }
      //Step.2 获取导出数据
      List<WmsLoc>  wmsLocList = wmsLocService.list(queryWrapper);

      // Step.3 组装pageList
      List<WmsLocPage> pageList = new ArrayList<WmsLocPage>();
      for (WmsLoc main : wmsLocList) {
          WmsLocPage vo = new WmsLocPage();
          BeanUtils.copyProperties(main, vo);
          List<WmsStation> wmsStationList = wmsStationService.selectByMainCode(main.getCode());
          vo.setWmsStationList(wmsStationList);
          pageList.add(vo);
      }

      // Step.4 AutoPoi 导出Excel
      ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
      mv.addObject(NormalExcelConstants.FILE_NAME, "库位管理列表");
      mv.addObject(NormalExcelConstants.CLASS, WmsLocPage.class);
      mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("库位管理数据", "导出人:"+sysUser.getRealname(), "库位管理"));
      mv.addObject(NormalExcelConstants.DATA_LIST, pageList);
      return mv;
    }

    /**
    * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:wms_loc:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
      MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
      Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
      for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
          // 获取上传文件对象
          MultipartFile file = entity.getValue();
          ImportParams params = new ImportParams();
          params.setTitleRows(2);
          params.setHeadRows(1);
          params.setNeedSave(true);
          try {
              List<WmsLocPage> list = ExcelImportUtil.importExcel(file.getInputStream(), WmsLocPage.class, params);
              for (WmsLocPage page : list) {
                  WmsLoc po = new WmsLoc();
                  BeanUtils.copyProperties(page, po);
                  wmsLocService.saveMain(po, page.getWmsStationList());
              }
              return Result.OK("文件导入成功！数据行数:" + list.size());
          } catch (Exception e) {
              log.error(e.getMessage(),e);
              return Result.error("文件导入失败:"+e.getMessage());
          } finally {
              try {
                  file.getInputStream().close();
              } catch (IOException e) {
                  e.printStackTrace();
              }
          }
      }
      return Result.OK("文件导入失败！");
    }

}
