package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.WmsContainerGoods;
import org.jeecg.modules.wms.service.IWmsContainerGoodsService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 容器货品
 * @Author: jeecg-boot
 * @Date:   2024-09-03
 * @Version: V1.0
 */
@Api(tags="容器货品")
@RestController
@RequestMapping("/wms/wmsContainerGoods")
@Slf4j
public class WmsContainerGoodsController extends JeecgController<WmsContainerGoods, IWmsContainerGoodsService> {
	@Autowired
	private IWmsContainerGoodsService wmsContainerGoodsService;
	
	/**
	 * 分页列表查询
	 *
	 * @param wmsContainerGoods
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "容器货品-分页列表查询")
	@ApiOperation(value="容器货品-分页列表查询", notes="容器货品-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<WmsContainerGoods>> queryPageList(WmsContainerGoods wmsContainerGoods,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<WmsContainerGoods> queryWrapper = QueryGenerator.initQueryWrapper(wmsContainerGoods, req.getParameterMap());
		Page<WmsContainerGoods> page = new Page<WmsContainerGoods>(pageNo, pageSize);
		IPage<WmsContainerGoods> pageList = wmsContainerGoodsService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param wmsContainerGoods
	 * @return
	 */
	@AutoLog(value = "容器货品-添加")
	@ApiOperation(value="容器货品-添加", notes="容器货品-添加")
	@RequiresPermissions("wms:wms_container_goods:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody WmsContainerGoods wmsContainerGoods) {
		wmsContainerGoodsService.save(wmsContainerGoods);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param wmsContainerGoods
	 * @return
	 */
	@AutoLog(value = "容器货品-编辑")
	@ApiOperation(value="容器货品-编辑", notes="容器货品-编辑")
	@RequiresPermissions("wms:wms_container_goods:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody WmsContainerGoods wmsContainerGoods) {
		wmsContainerGoodsService.updateById(wmsContainerGoods);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "容器货品-通过id删除")
	@ApiOperation(value="容器货品-通过id删除", notes="容器货品-通过id删除")
	@RequiresPermissions("wms:wms_container_goods:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		wmsContainerGoodsService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "容器货品-批量删除")
	@ApiOperation(value="容器货品-批量删除", notes="容器货品-批量删除")
	@RequiresPermissions("wms:wms_container_goods:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.wmsContainerGoodsService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "容器货品-通过id查询")
	@ApiOperation(value="容器货品-通过id查询", notes="容器货品-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<WmsContainerGoods> queryById(@RequestParam(name="id",required=true) String id) {
		WmsContainerGoods wmsContainerGoods = wmsContainerGoodsService.getById(id);
		if(wmsContainerGoods==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(wmsContainerGoods);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param wmsContainerGoods
    */
    @RequiresPermissions("wms:wms_container_goods:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsContainerGoods wmsContainerGoods) {
        return super.exportXls(request, wmsContainerGoods, WmsContainerGoods.class, "容器货品");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:wms_container_goods:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, WmsContainerGoods.class);
    }

}
