package org.jeecg.modules.wms.controller;

import com.alibaba.fastjson.JSON;
import org.jeecg.common.system.query.QueryGenerator;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.pad.api.WmsApi;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CreateOutTaskReq;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;

import java.util.Arrays;

import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.WmsContainerGoods;
import org.jeecg.modules.wms.entity.WmsContainer;
import org.jeecg.modules.wms.service.IWmsContainerService;
import org.jeecg.modules.wms.service.IWmsContainerGoodsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.shiro.authz.annotation.RequiresPermissions;

/**
 * @Description: 容器
 * @Author: jeecg-boot
 * @Date: 2024-07-30
 * @Version: V1.0
 */
@Api(tags = "容器")
@RestController
@RequestMapping("/wms/wmsContainer")
@Slf4j
public class WmsContainerController extends JeecgController<WmsContainer, IWmsContainerService> {

    @Autowired
    private IWmsContainerService wmsContainerService;

    @Autowired
    private IWmsContainerGoodsService wmsContainerGoodsService;

    @Resource
    private WmsApi wmsApi;


    /*---------------------------------主表处理-begin-------------------------------------*/

    /**
     * 分页列表查询
     *
     * @param wmsContainer
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    //@AutoLog(value = "容器-分页列表查询")
    @ApiOperation(value = "容器-分页列表查询", notes = "容器-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<WmsContainer>> queryPageList(WmsContainer wmsContainer,
                                                     @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                     @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                     HttpServletRequest req) {
        QueryWrapper<WmsContainer> queryWrapper = QueryGenerator.initQueryWrapper(wmsContainer, req.getParameterMap());
        Page<WmsContainer> page = new Page<WmsContainer>(pageNo, pageSize);
        IPage<WmsContainer> pageList = wmsContainerService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param wmsContainer
     * @return
     */
    @AutoLog(value = "容器-添加")
    @ApiOperation(value = "容器-添加", notes = "容器-添加")
    @RequiresPermissions("wms:wms_container:add")
    @PostMapping(value = "/add")
    public Result<String> add(@RequestBody WmsContainer wmsContainer) {
        wmsContainerService.save(wmsContainer);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param wmsContainer
     * @return
     */
    @AutoLog(value = "容器-编辑")
    @ApiOperation(value = "容器-编辑", notes = "容器-编辑")
    @RequiresPermissions("wms:wms_container:edit")
    @RequestMapping(value = "/edit", method = {RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody WmsContainer wmsContainer) {
        wmsContainerService.updateById(wmsContainer);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "容器-通过id删除")
    @ApiOperation(value = "容器-通过id删除", notes = "容器-通过id删除")
    @RequiresPermissions("wms:wms_container:delete")
    @DeleteMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name = "id", required = true) String id) {
        wmsContainerService.delMain(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "容器-批量删除")
    @ApiOperation(value = "容器-批量删除", notes = "容器-批量删除")
    @RequiresPermissions("wms:wms_container:deleteBatch")
    @DeleteMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.wmsContainerService.delBatchMain(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 导出
     *
     * @return
     */
    @RequiresPermissions("wms:wms_container:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsContainer wmsContainer) {
        return super.exportXls(request, wmsContainer, WmsContainer.class, "容器");
    }

    /**
     * 导入
     *
     * @return
     */
    @RequiresPermissions("wms:wms_container:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, WmsContainer.class);
    }
    /*---------------------------------主表处理-end-------------------------------------*/


    /*--------------------------------子表处理-容器货品-begin----------------------------------------------*/

    /**
     * 通过主表ID查询
     *
     * @return
     */
    //@AutoLog(value = "容器货品-通过主表ID查询")
    @ApiOperation(value = "容器货品-通过主表ID查询", notes = "容器货品-通过主表ID查询")
    @GetMapping(value = "/listWmsContainerGoodsByMainId")
    public Result<IPage<WmsContainerGoods>> listWmsContainerGoodsByMainId(WmsContainerGoods wmsContainerGoods,
                                                                          @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                                          @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                                          HttpServletRequest req) {
        QueryWrapper<WmsContainerGoods> queryWrapper = QueryGenerator.initQueryWrapper(wmsContainerGoods, req.getParameterMap());
        Page<WmsContainerGoods> page = new Page<WmsContainerGoods>(pageNo, pageSize);
        IPage<WmsContainerGoods> pageList = wmsContainerGoodsService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param wmsContainerGoods
     * @return
     */
    @AutoLog(value = "容器货品-添加")
    @ApiOperation(value = "容器货品-添加", notes = "容器货品-添加")
    @PostMapping(value = "/addWmsContainerGoods")
    public Result<String> addWmsContainerGoods(@RequestBody WmsContainerGoods wmsContainerGoods) {
        wmsContainerGoodsService.save(wmsContainerGoods);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param wmsContainerGoods
     * @return
     */
    @AutoLog(value = "容器货品-编辑")
    @ApiOperation(value = "容器货品-编辑", notes = "容器货品-编辑")
    @RequestMapping(value = "/editWmsContainerGoods", method = {RequestMethod.PUT, RequestMethod.POST})
    public Result<String> editWmsContainerGoods(@RequestBody WmsContainerGoods wmsContainerGoods) {
        wmsContainerGoodsService.updateById(wmsContainerGoods);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "容器货品-通过id删除")
    @ApiOperation(value = "容器货品-通过id删除", notes = "容器货品-通过id删除")
    @DeleteMapping(value = "/deleteWmsContainerGoods")
    public Result<String> deleteWmsContainerGoods(@RequestParam(name = "id", required = true) String id) {
        wmsContainerGoodsService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "容器货品-批量删除")
    @ApiOperation(value = "容器货品-批量删除", notes = "容器货品-批量删除")
    @DeleteMapping(value = "/deleteBatchWmsContainerGoods")
    public Result<String> deleteBatchWmsContainerGoods(@RequestParam(name = "ids", required = true) String ids) {
        this.wmsContainerGoodsService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 导出
     *
     * @return
     */
    @RequestMapping(value = "/exportWmsContainerGoods")
    public ModelAndView exportWmsContainerGoods(HttpServletRequest request, WmsContainerGoods wmsContainerGoods) {
        // Step.1 组装查询条件
        QueryWrapper<WmsContainerGoods> queryWrapper = QueryGenerator.initQueryWrapper(wmsContainerGoods, request.getParameterMap());
        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

        // Step.2 获取导出数据
        List<WmsContainerGoods> pageList = wmsContainerGoodsService.list(queryWrapper);
        List<WmsContainerGoods> exportList = null;

        // 过滤选中数据
        String selections = request.getParameter("selections");
        if (oConvertUtils.isNotEmpty(selections)) {
            List<String> selectionList = Arrays.asList(selections.split(","));
            exportList = pageList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
        } else {
            exportList = pageList;
        }

        // Step.3 AutoPoi 导出Excel
        ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
        //此处设置的filename无效,前端会重更新设置一下
        mv.addObject(NormalExcelConstants.FILE_NAME, "容器货品");
        mv.addObject(NormalExcelConstants.CLASS, WmsContainerGoods.class);
        mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("容器货品报表", "导出人:" + sysUser.getRealname(), "容器货品"));
        mv.addObject(NormalExcelConstants.DATA_LIST, exportList);
        return mv;
    }

    /**
     * 导入
     *
     * @return
     */
    @RequestMapping(value = "/importWmsContainerGoods/{mainId}")
    public Result<?> importWmsContainerGoods(HttpServletRequest request, HttpServletResponse response, @PathVariable("mainId") String mainId) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            // 获取上传文件对象
            MultipartFile file = entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List<WmsContainerGoods> list = ExcelImportUtil.importExcel(file.getInputStream(), WmsContainerGoods.class, params);
                for (WmsContainerGoods temp : list) {
                    temp.setContainerCode(mainId);
                }
                long start = System.currentTimeMillis();
                wmsContainerGoodsService.saveBatch(list);
                log.info("消耗时间" + (System.currentTimeMillis() - start) + "毫秒");
                return Result.OK("文件导入成功！数据行数：" + list.size());
            } catch (Exception e) {
                log.error(e.getMessage(), e);
                return Result.error("文件导入失败:" + e.getMessage());
            } finally {
                try {
                    file.getInputStream().close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error("文件导入失败！");
    }

    /*--------------------------------子表处理-容器货品-end----------------------------------------------*/

    /**
     * 通过id删除
     *
     * @param wmsContainer
     * @return
     */
    @AutoLog(value = "容器货品-通过请求货箱对象取货")
    @ApiOperation(value = "容器货品-通过请求货箱对象取货", notes = "容器货品-通过请求货箱对象取货")
    @PostMapping(value = "/takeOutOne")
    public Result taskOutOne(@RequestBody WmsContainer wmsContainer) {
        log.info("取货参数: {}", JSON.toJSONString(wmsContainer));
        //获取货箱
        CreateOutTaskReq req = new CreateOutTaskReq();
        req.setBox(wmsContainer.getCode());
        req.setFromLoc(wmsContainer.getLocCode());
        req.setToLoc(wmsContainer.getToLocCode());

        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        req.setUser(sysUser.getUsername());
        WmsRes res= wmsApi.createOutTask(req);
        return res.getCode()==200?Result.OK(res.getMsg()):Result.error(res.getMsg());
    }

}
