package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.WmsCheckBillDetail;
import org.jeecg.modules.wms.service.IWmsCheckBillDetailService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 盘点单详情表
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@Api(tags="盘点单详情表")
@RestController
@RequestMapping("/wms/wmsCheckBillDetail")
@Slf4j
public class WmsCheckBillDetailController extends JeecgController<WmsCheckBillDetail, IWmsCheckBillDetailService> {
	@Autowired
	private IWmsCheckBillDetailService wmsCheckBillDetailService;
	
	/**
	 * 分页列表查询
	 *
	 * @param wmsCheckBillDetail
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "盘点单详情表-分页列表查询")
	@ApiOperation(value="盘点单详情表-分页列表查询", notes="盘点单详情表-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<WmsCheckBillDetail>> queryPageList(WmsCheckBillDetail wmsCheckBillDetail,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<WmsCheckBillDetail> queryWrapper = QueryGenerator.initQueryWrapper(wmsCheckBillDetail, req.getParameterMap());
		Page<WmsCheckBillDetail> page = new Page<WmsCheckBillDetail>(pageNo, pageSize);
		IPage<WmsCheckBillDetail> pageList = wmsCheckBillDetailService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param wmsCheckBillDetail
	 * @return
	 */
	@AutoLog(value = "盘点单详情表-添加")
	@ApiOperation(value="盘点单详情表-添加", notes="盘点单详情表-添加")
	@RequiresPermissions("wms:wms_check_bill_detail:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody WmsCheckBillDetail wmsCheckBillDetail) {
		wmsCheckBillDetailService.save(wmsCheckBillDetail);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param wmsCheckBillDetail
	 * @return
	 */
	@AutoLog(value = "盘点单详情表-编辑")
	@ApiOperation(value="盘点单详情表-编辑", notes="盘点单详情表-编辑")
	@RequiresPermissions("wms:wms_check_bill_detail:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody WmsCheckBillDetail wmsCheckBillDetail) {
		wmsCheckBillDetailService.updateById(wmsCheckBillDetail);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "盘点单详情表-通过id删除")
	@ApiOperation(value="盘点单详情表-通过id删除", notes="盘点单详情表-通过id删除")
	@RequiresPermissions("wms:wms_check_bill_detail:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		wmsCheckBillDetailService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "盘点单详情表-批量删除")
	@ApiOperation(value="盘点单详情表-批量删除", notes="盘点单详情表-批量删除")
	@RequiresPermissions("wms:wms_check_bill_detail:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.wmsCheckBillDetailService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "盘点单详情表-通过id查询")
	@ApiOperation(value="盘点单详情表-通过id查询", notes="盘点单详情表-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<WmsCheckBillDetail> queryById(@RequestParam(name="id",required=true) String id) {
		WmsCheckBillDetail wmsCheckBillDetail = wmsCheckBillDetailService.getById(id);
		if(wmsCheckBillDetail==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(wmsCheckBillDetail);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param wmsCheckBillDetail
    */
    @RequiresPermissions("wms:wms_check_bill_detail:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsCheckBillDetail wmsCheckBillDetail) {
        return super.exportXls(request, wmsCheckBillDetail, WmsCheckBillDetail.class, "盘点单详情表");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:wms_check_bill_detail:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, WmsCheckBillDetail.class);
    }

}
