package org.jeecg.modules.wms.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import org.jeecg.common.system.query.QueryGenerator;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CheckCreateReq;
import org.jeecg.modules.pad.api.bean.req.CheckUpdateReq;
import org.jeecg.modules.wms.entity.WmsCheckBillDetail;
import org.jeecg.modules.wms.service.IWmsCheckBillDetailService;
import org.jeecg.modules.wms.vo.OrderInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import java.util.Arrays;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.WmsCheckBill;
import org.jeecg.modules.wms.service.IWmsCheckBillService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 盘点单
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@Api(tags="盘点单")
@RestController
@RequestMapping("/wms/wmsCheckBill")
@Slf4j
public class WmsCheckBillController extends JeecgController<WmsCheckBill, IWmsCheckBillService> {

	@Autowired
	private IWmsCheckBillService wmsCheckBillService;

	@Autowired
	private IWmsCheckBillDetailService wmsCheckBillEntryService;


	/*---------------------------------主表处理-begin-------------------------------------*/

	/**
	 * 分页列表查询
	 * @param wmsCheckBill
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "盘点单-分页列表查询")
	@ApiOperation(value="盘点单-分页列表查询", notes="盘点单-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<WmsCheckBill>> queryPageList(WmsCheckBill wmsCheckBill,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<WmsCheckBill> queryWrapper = QueryGenerator.initQueryWrapper(wmsCheckBill, req.getParameterMap());
		Page<WmsCheckBill> page = new Page<WmsCheckBill>(pageNo, pageSize);
		IPage<WmsCheckBill> pageList = wmsCheckBillService.page(page, queryWrapper);
		return Result.OK(pageList);
	}

	/**
     *   添加
     * @param wmsCheckBill
     * @return
     */
    @AutoLog(value = "盘点单-添加")
    @ApiOperation(value="盘点单-添加", notes="盘点单-添加")
    @RequiresPermissions("wms:wms_check_bill:add")
    @PostMapping(value = "/add")
    public Result<String> add(@RequestBody WmsCheckBill wmsCheckBill) {
        wmsCheckBillService.save(wmsCheckBill);
        return Result.OK("添加成功！");
    }

    /**
     *  编辑
     * @param wmsCheckBill
     * @return
     */
    @AutoLog(value = "盘点单-编辑")
    @ApiOperation(value="盘点单-编辑", notes="盘点单-编辑")
    @RequiresPermissions("wms:wms_check_bill:edit")
    @RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
    public Result<String> edit(@RequestBody WmsCheckBill wmsCheckBill) {
        wmsCheckBillService.updateById(wmsCheckBill);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     * @param id
     * @return
     */
    @AutoLog(value = "盘点单-通过id删除")
    @ApiOperation(value="盘点单-通过id删除", notes="盘点单-通过id删除")
    @RequiresPermissions("wms:wms_check_bill:delete")
    @DeleteMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name="id",required=true) String id) {
        wmsCheckBillService.delMain(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @AutoLog(value = "盘点单-批量删除")
    @ApiOperation(value="盘点单-批量删除", notes="盘点单-批量删除")
    @RequiresPermissions("wms:wms_check_bill:deleteBatch")
    @DeleteMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
        this.wmsCheckBillService.delBatchMain(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 导出
     * @return
     */
    @RequiresPermissions("wms:wms_check_bill:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsCheckBill wmsCheckBill) {
        return super.exportXls(request, wmsCheckBill, WmsCheckBill.class, "盘点单");
    }

    /**
     * 导入
     * @return
     */
    @RequiresPermissions("wms:wms_check_bill:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, WmsCheckBill.class);
    }
	/*---------------------------------主表处理-end-------------------------------------*/
	

    /*--------------------------------子表处理-盘点单库存分录-begin----------------------------------------------*/
	/**
	 * 通过主表ID查询
	 * @return
	 */
	//@AutoLog(value = "盘点单库存分录-通过主表ID查询")
	@ApiOperation(value="盘点单库存分录-通过主表ID查询", notes="盘点单库存分录-通过主表ID查询")
	@GetMapping(value = "/listWmsCheckBillEntryByMainId")
    public Result<IPage<WmsCheckBillDetail>> listWmsCheckBillEntryByMainId(WmsCheckBillDetail wmsCheckBillEntry,
																		   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
																		   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
																		   HttpServletRequest req) {
        QueryWrapper<WmsCheckBillDetail> queryWrapper = QueryGenerator.initQueryWrapper(wmsCheckBillEntry, req.getParameterMap());
        Page<WmsCheckBillDetail> page = new Page<WmsCheckBillDetail>(pageNo, pageSize);
        IPage<WmsCheckBillDetail> pageList = wmsCheckBillEntryService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

	/**
	 * 添加
	 * @param wmsCheckBillEntry
	 * @return
	 */
	@AutoLog(value = "盘点单库存分录-添加")
	@ApiOperation(value="盘点单库存分录-添加", notes="盘点单库存分录-添加")
	@PostMapping(value = "/addWmsCheckBillEntry")
	public Result<String> addWmsCheckBillEntry(@RequestBody WmsCheckBillDetail wmsCheckBillEntry) {
		wmsCheckBillEntryService.save(wmsCheckBillEntry);
		return Result.OK("添加成功！");
	}

    /**
	 * 编辑
	 * @param wmsCheckBillEntry
	 * @return
	 */
	@AutoLog(value = "盘点单库存分录-编辑")
	@ApiOperation(value="盘点单库存分录-编辑", notes="盘点单库存分录-编辑")
	@RequestMapping(value = "/editWmsCheckBillEntry", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> editWmsCheckBillEntry(@RequestBody WmsCheckBillDetail wmsCheckBillEntry) {
		wmsCheckBillEntryService.updateById(wmsCheckBillEntry);
		return Result.OK("编辑成功!");
	}

	/**
	 * 通过id删除
	 * @param id
	 * @return
	 */
	@AutoLog(value = "盘点单库存分录-通过id删除")
	@ApiOperation(value="盘点单库存分录-通过id删除", notes="盘点单库存分录-通过id删除")
	@DeleteMapping(value = "/deleteWmsCheckBillEntry")
	public Result<String> deleteWmsCheckBillEntry(@RequestParam(name="id",required=true) String id) {
		wmsCheckBillEntryService.removeById(id);
		return Result.OK("删除成功!");
	}

	/**
	 * 批量删除
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "盘点单库存分录-批量删除")
	@ApiOperation(value="盘点单库存分录-批量删除", notes="盘点单库存分录-批量删除")
	@DeleteMapping(value = "/deleteBatchWmsCheckBillEntry")
	public Result<String> deleteBatchWmsCheckBillEntry(@RequestParam(name="ids",required=true) String ids) {
	    this.wmsCheckBillEntryService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}

    /**
     * 导出
     * @return
     */
    @RequestMapping(value = "/exportWmsCheckBillEntry")
    public ModelAndView exportWmsCheckBillEntry(HttpServletRequest request, WmsCheckBillDetail wmsCheckBillEntry) {
		 // Step.1 组装查询条件
		 QueryWrapper<WmsCheckBillDetail> queryWrapper = QueryGenerator.initQueryWrapper(wmsCheckBillEntry, request.getParameterMap());
		 LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

		 // Step.2 获取导出数据
		 List<WmsCheckBillDetail> pageList = wmsCheckBillEntryService.list(queryWrapper);
		 List<WmsCheckBillDetail> exportList = null;

		 // 过滤选中数据
		 String selections = request.getParameter("selections");
		 if (oConvertUtils.isNotEmpty(selections)) {
			 List<String> selectionList = Arrays.asList(selections.split(","));
			 exportList = pageList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
		 } else {
			 exportList = pageList;
		 }

		 // Step.3 AutoPoi 导出Excel
		 ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
		 //此处设置的filename无效,前端会重更新设置一下
		 mv.addObject(NormalExcelConstants.FILE_NAME, "盘点单库存分录");
		 mv.addObject(NormalExcelConstants.CLASS, WmsCheckBillDetail.class);
		 mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("盘点单库存分录报表", "导出人:" + sysUser.getRealname(), "盘点单库存分录"));
		 mv.addObject(NormalExcelConstants.DATA_LIST, exportList);
		 return mv;
    }

    /**
     * 导入
     * @return
     */
    @RequestMapping(value = "/importWmsCheckBillEntry/{mainId}")
    public Result<?> importWmsCheckBillEntry(HttpServletRequest request, HttpServletResponse response, @PathVariable("mainId") int mainId) {
		 MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		 Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		 for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
       // 获取上传文件对象
			 MultipartFile file = entity.getValue();
			 ImportParams params = new ImportParams();
			 params.setTitleRows(2);
			 params.setHeadRows(1);
			 params.setNeedSave(true);
			 try {
				 List<WmsCheckBillDetail> list = ExcelImportUtil.importExcel(file.getInputStream(), WmsCheckBillDetail.class, params);
				 for (WmsCheckBillDetail temp : list) {
                    temp.setOrderId(mainId);
				 }
				 long start = System.currentTimeMillis();
				 wmsCheckBillEntryService.saveBatch(list);
				 log.info("消耗时间" + (System.currentTimeMillis() - start) + "毫秒");
				 return Result.OK("文件导入成功！数据行数：" + list.size());
			 } catch (Exception e) {
				 log.error(e.getMessage(), e);
				 return Result.error("文件导入失败:" + e.getMessage());
			 } finally {
				 try {
					 file.getInputStream().close();
				 } catch (IOException e) {
					 e.printStackTrace();
				 }
			 }
		 }
		 return Result.error("文件导入失败！");
    }

    /*--------------------------------子表处理-盘点单库存分录-end----------------------------------------------*/


	 @PostMapping(value = "/create")
	 public Result<?> create(@RequestBody CheckCreateReq req) {
		 if (req == null){
			 return Result.error("参数异常");
		 }

		 req.setCheckDate(DateUtil.formatDate(new Date()));
		 req.setNote("");

//		 LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
//		 if (sysUser == null){
//			 return Result.error("用户未登录");
//		 }
//		 req.setOperator(sysUser.getUsername());

		 WmsRes<?> result = wmsCheckBillService.create(req);
		 if (result == null){
			 return Result.error("请求异常");
		 }

		 if (result.getCode() != 200){
			 return Result.error(result.getMsg());
		 }

		 return Result.OK(result.getData());
	 }

	 @PostMapping(value = "/pullDown")
	 public Result<?> pullDown(@RequestBody OrderInfo orderInfo) {
		 if (orderInfo == null || StrUtil.isBlank(orderInfo.getOrderNo())){
			 return Result.error("参数异常");
		 }
		 WmsRes<?> result = wmsCheckBillService.pullDown(orderInfo.getOrderNo());
		 if (result == null){
			 return Result.error("请求异常");
		 }

		 if (result.getCode() != 200){
			 return Result.error(result.getMsg());
		 }

		 return Result.OK(result.getData());
	 }

	 @PostMapping(value = "/updateOrder")
	 public Result<?> updateOrder(@RequestBody CheckUpdateReq req) {
		 if (req == null){
			 return Result.error("参数异常");
		 }

		 req.setCheckDate(DateUtil.formatDate(new Date()));
		 req.setNote("");

		 WmsRes<?> result = wmsCheckBillService.updateOrder(req);
		 if (result == null){
			 return Result.error("请求异常");
		 }

		 if (result.getCode() != 200){
			 return Result.error(result.getMsg());
		 }

		 return Result.OK(result.getData());
	 }

	 @PostMapping(value = "/cancel")
	 public Result<?> cancel(@RequestBody OrderInfo orderInfo) {
		 if (orderInfo == null || StrUtil.isBlank(orderInfo.getOrderNo())){
			 return Result.error("参数异常");
		 }
		 WmsRes<?> result = wmsCheckBillService.cancel(orderInfo.getOrderNo());
		 if (result == null){
			 return Result.error("请求异常");
		 }

		 if (result.getCode() != 200){
			 return Result.error(result.getMsg());
		 }

		 return Result.OK(result.getData());
	 }

	 @PostMapping(value = "/syncInventory")
	 public Result<?> syncInventory(@RequestBody OrderInfo orderInfo) {
		 if (orderInfo == null || StrUtil.isBlank(orderInfo.getOrderNo())){
			 return Result.error("参数异常");
		 }
		 WmsRes<?> result = wmsCheckBillService.syncInventory(orderInfo.getOrderNo());
		 if (result == null){
			 return Result.error("请求异常");
		 }

		 if (result.getCode() != 200){
			 return Result.error(result.getMsg());
		 }

		 return Result.OK(result.getData());
	 }

}
