package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.wms.entity.WmsArea;
import org.jeecg.modules.wms.service.IWmsAreaService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 区域管理
 * @Author: jeecg-boot
 * @Date:   2024-09-03
 * @Version: V1.0
 */
@Api(tags="区域管理")
@RestController
@RequestMapping("/wms/wmsArea")
@Slf4j
public class WmsAreaController extends JeecgController<WmsArea, IWmsAreaService> {
	@Autowired
	private IWmsAreaService wmsAreaService;
	
	/**
	 * 分页列表查询
	 *
	 * @param wmsArea
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "区域管理-分页列表查询")
	@ApiOperation(value="区域管理-分页列表查询", notes="区域管理-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<WmsArea>> queryPageList(WmsArea wmsArea,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<WmsArea> queryWrapper = QueryGenerator.initQueryWrapper(wmsArea, req.getParameterMap());
		Page<WmsArea> page = new Page<WmsArea>(pageNo, pageSize);
		IPage<WmsArea> pageList = wmsAreaService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param wmsArea
	 * @return
	 */
	@AutoLog(value = "区域管理-添加")
	@ApiOperation(value="区域管理-添加", notes="区域管理-添加")
	@RequiresPermissions("wms:wms_area:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody WmsArea wmsArea) {
		wmsAreaService.save(wmsArea);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param wmsArea
	 * @return
	 */
	@AutoLog(value = "区域管理-编辑")
	@ApiOperation(value="区域管理-编辑", notes="区域管理-编辑")
	@RequiresPermissions("wms:wms_area:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody WmsArea wmsArea) {
		wmsAreaService.updateById(wmsArea);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "区域管理-通过id删除")
	@ApiOperation(value="区域管理-通过id删除", notes="区域管理-通过id删除")
	@RequiresPermissions("wms:wms_area:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		wmsAreaService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "区域管理-批量删除")
	@ApiOperation(value="区域管理-批量删除", notes="区域管理-批量删除")
	@RequiresPermissions("wms:wms_area:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.wmsAreaService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "区域管理-通过id查询")
	@ApiOperation(value="区域管理-通过id查询", notes="区域管理-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<WmsArea> queryById(@RequestParam(name="id",required=true) String id) {
		WmsArea wmsArea = wmsAreaService.getById(id);
		if(wmsArea==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(wmsArea);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param wmsArea
    */
    @RequiresPermissions("wms:wms_area:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, WmsArea wmsArea) {
        return super.exportXls(request, wmsArea, WmsArea.class, "区域管理");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:wms_area:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, WmsArea.class);
    }

}
