package org.jeecg.modules.wms.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoDict;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.shiro.IgnoreAuth;
import org.jeecg.modules.wms.entity.ViewWmsStockLocSku;
import org.jeecg.modules.wms.service.IViewWmsStockLocSkuService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.modules.wms.vo.ViewStockStatisticsVo;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.apache.shiro.authz.annotation.RequiresPermissions;

 /**
 * @Description: 库存信息
 * @Author: jeecg-boot
 * @Date:   2024-09-03
 * @Version: V1.0
 */
@Api(tags="库存信息")
@RestController
@RequestMapping("/wms/viewWmsStockLocSku")
@Slf4j
public class ViewWmsStockLocSkuController extends JeecgController<ViewWmsStockLocSku, IViewWmsStockLocSkuService> {
	@Autowired
	private IViewWmsStockLocSkuService viewWmsStockLocSkuService;
	
	/**
	 * 分页列表查询
	 *
	 * @param viewWmsStockLocSku
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "库存信息-分页列表查询")
	@ApiOperation(value="库存信息-分页列表查询", notes="库存信息-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<ViewWmsStockLocSku>> queryPageList(ViewWmsStockLocSku viewWmsStockLocSku,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<ViewWmsStockLocSku> queryWrapper = QueryGenerator.initQueryWrapper(viewWmsStockLocSku, req.getParameterMap());
		Page<ViewWmsStockLocSku> page = new Page<ViewWmsStockLocSku>(pageNo, pageSize);
		IPage<ViewWmsStockLocSku> pageList = viewWmsStockLocSkuService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param viewWmsStockLocSku
	 * @return
	 */
	@AutoLog(value = "库存信息-添加")
	@ApiOperation(value="库存信息-添加", notes="库存信息-添加")
	@RequiresPermissions("wms:view_wms_stock_loc_sku:add")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody ViewWmsStockLocSku viewWmsStockLocSku) {
		viewWmsStockLocSkuService.save(viewWmsStockLocSku);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param viewWmsStockLocSku
	 * @return
	 */
	@AutoLog(value = "库存信息-编辑")
	@ApiOperation(value="库存信息-编辑", notes="库存信息-编辑")
	@RequiresPermissions("wms:view_wms_stock_loc_sku:edit")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody ViewWmsStockLocSku viewWmsStockLocSku) {
		viewWmsStockLocSkuService.updateById(viewWmsStockLocSku);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "库存信息-通过id删除")
	@ApiOperation(value="库存信息-通过id删除", notes="库存信息-通过id删除")
	@RequiresPermissions("wms:view_wms_stock_loc_sku:delete")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		viewWmsStockLocSkuService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "库存信息-批量删除")
	@ApiOperation(value="库存信息-批量删除", notes="库存信息-批量删除")
	@RequiresPermissions("wms:view_wms_stock_loc_sku:deleteBatch")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.viewWmsStockLocSkuService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "库存信息-通过id查询")
	@ApiOperation(value="库存信息-通过id查询", notes="库存信息-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<ViewWmsStockLocSku> queryById(@RequestParam(name="id",required=true) String id) {
		ViewWmsStockLocSku viewWmsStockLocSku = viewWmsStockLocSkuService.getById(id);
		if(viewWmsStockLocSku==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(viewWmsStockLocSku);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param viewWmsStockLocSku
    */
    @RequiresPermissions("wms:view_wms_stock_loc_sku:exportXls")
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ViewWmsStockLocSku viewWmsStockLocSku) {
        return super.exportXls(request, viewWmsStockLocSku, ViewWmsStockLocSku.class, "库存信息");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequiresPermissions("wms:view_wms_stock_loc_sku:importExcel")
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ViewWmsStockLocSku.class);
    }

	 @GetMapping(value = "/statistics")
	 @IgnoreAuth
	 public Result<IPage<ViewStockStatisticsVo>> statistics(ViewWmsStockLocSku viewWmsStockLocSku, HttpServletRequest req)
	 {
		 QueryWrapper<ViewWmsStockLocSku> queryWrapper = QueryGenerator.initQueryWrapper(viewWmsStockLocSku, null);
		 List<ViewStockStatisticsVo> map = viewWmsStockLocSkuService.statistics(queryWrapper);
		 IPage<ViewStockStatisticsVo> page = new Page<>(1, 10000);
		 page.setRecords(map);
		 return Result.OK(page);
	 }
}
