package org.jeecg.modules.pad.service.impl;

import org.jeecg.modules.pad.api.WmsApi;
import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.TaskReq;
import org.jeecg.modules.pad.api.bean.req.TaskUpdateReq;
import org.jeecg.modules.pad.api.bean.res.TaskInfo;
import org.jeecg.modules.pad.service.IPdaTaskSearch;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class PdaTaskSearchImpl implements IPdaTaskSearch {
    @Resource
    private WmsApi wmsApi;
    @Override
    public WmsPageRes<TaskInfo> getTaskInfo(TaskReq req) {
        return wmsApi.task(req);
    }

    @Override
    public WmsRes<?> manualTaskUpdate(TaskUpdateReq req) {
        return wmsApi.updateTaskStatus(req);
    }
}
