package org.jeecg.modules.pad.service.impl;

import org.jeecg.modules.pad.api.WmsStationApi;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.StationReleaseReq;
import org.jeecg.modules.pad.api.bean.res.StationInfo;
import org.jeecg.modules.pad.service.IPdaStation;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class PdaStationImpl implements IPdaStation {
    @Resource
    private WmsStationApi wmsStationApi;

    @Override
    public WmsRes<StationInfo> getStationInfo(String stationCode) {
        return wmsStationApi.getStationInfo(stationCode);
    }

    @Override
    public WmsRes<?> release(StationReleaseReq req) {
        return wmsStationApi.release(req);
    }
}
