package org.jeecg.modules.pad.service.impl;

import org.jeecg.modules.pad.api.WmsApi;
import org.jeecg.modules.pad.api.WmsSoApi;
import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.*;
import org.jeecg.modules.pad.api.bean.res.*;
import org.jeecg.modules.pad.service.IPdaSorting;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class PdaSortingImpl implements IPdaSorting {
    @Resource
    private WmsSoApi wmsSoApi;
    @Override
    public WmsRes<SoListGoods> getOutMaterials(SoListGoodsReq req) {
        return wmsSoApi.listGoods(req);
    }

    @Override
    public WmsPageRes<SoListGoods.GoodsInfo> getOutMaterialsPage(SoListGoodsReq req, Integer pageNo, Integer pageSize) {
        return wmsSoApi.listGoodsPro(req, pageNo, pageSize);
    }

    @Override
    public WmsRes<SoFirstPickInfo> getPickMaterials(SoListFirstPickReq req) {
        return wmsSoApi.listFirstPick(req);
    }

    @Override
    public WmsRes<?> stockOut(SoPullFirstPickReq req) {
        return wmsSoApi.pullFirstPick(req);
    }

    @Override
    public WmsRes<SoFirstPickByCode> getPalletInfo(String palletCode) {
        return wmsSoApi.listFirstPickByCode(palletCode);
    }

    @Override
    public WmsRes<?> pick(SoExecuteFirstPickReq req) {
        return wmsSoApi.executeFirstPick(req);
    }

    @Override
    public WmsRes<SoListRestPick> getExcessMaterials(String palletCode) {
        return wmsSoApi.listRestPick(palletCode);
    }

    @Override
    public WmsRes<?> returnMaterials(SoReturnRestPickReq req) {
        return wmsSoApi.returnRestPick(req);
    }

    @Override
    public WmsRes<GoodsTypeInfo> getGoodsTypeList() {
        return wmsSoApi.getGoodsTypeList();
    }

    @Override
    public WmsRes<ResponsibleUserInfo> getResponsibleUserList() {
        return wmsSoApi.getResponsibleUserList();
    }

    @Override
    public WmsRes<SoBoxInfo> executeFirstPickPro(SoExecuteFirstPickProReq req) {
        return wmsSoApi.executeFirstPickPro(req);
    }

    @Override
    public WmsRes<?> finishFirstPick(SoExecuteFirstPickProReq req) {
        return wmsSoApi.finishFirstPick(req);
    }
}
