package org.jeecg.modules.pad.service.impl;

import org.jeecg.modules.pad.api.WmsPalletApi;
import org.jeecg.modules.pad.api.WmsSoApi;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.MergeReq;
import org.jeecg.modules.pad.api.bean.res.SoListRestPick;
import org.jeecg.modules.pad.service.IPdaMergePallets;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class PdaMergePalletsImpl implements IPdaMergePallets {
    @Resource
    private WmsSoApi wmsSoApi;
    @Resource
    private WmsPalletApi wmsPalletApi;
    @Override
    public WmsRes<SoListRestPick> getExcessMaterials(String palletCode) {
        return wmsSoApi.listRestPick(palletCode);
    }

    @Override
    public WmsRes<?> mergePallets(MergeReq req) {
        return wmsPalletApi.merge(req);
    }
}
