package org.jeecg.modules.pad.service.impl;

import org.jeecg.modules.pad.api.WmsApi;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CreateOutTaskReq;
import org.jeecg.modules.pad.api.bean.req.InventoryReq;
import org.jeecg.modules.pad.api.bean.res.InternalInventory;
import org.jeecg.modules.pad.service.IPdaManualStorageOut;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class PdaManualStorageOutImpl implements IPdaManualStorageOut {
    @Resource
    private WmsApi wmsApi;
    @Override
    public WmsRes<InternalInventory> getMaterialInfoByCode(InventoryReq req) {
        return wmsApi.internalInventory(req);
    }

    @Override
    public WmsRes<?> manualStorageOut(CreateOutTaskReq req) {
        return wmsApi.createOutTask(req);
    }
}
