package org.jeecg.modules.pad.service.impl;

import cn.hutool.core.util.StrUtil;
import lombok.AllArgsConstructor;
import org.jeecg.modules.pad.api.WmsApi;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CreatePutTaskReq;
import org.jeecg.modules.pad.api.bean.req.GoodsDetailReq;
import org.jeecg.modules.pad.api.bean.res.GoodsDetail;
import org.jeecg.modules.pad.service.IPdaManualStorageIn;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class PdaManualStorageInImpl implements IPdaManualStorageIn {
    @Resource
    private WmsApi wmsApi;
    @Override
    public WmsRes<GoodsDetail> getMaterialInfoByCode(String code) {
        GoodsDetailReq req = new GoodsDetailReq();
        req.setQrCode(code);
        return wmsApi.goodsDetails(req);
    }

    @Override
    public WmsRes<?> manualStorageIn(CreatePutTaskReq req) {
        return wmsApi.createPutTask(req);
    }
}
