package org.jeecg.modules.pad.service.impl;

import org.jeecg.modules.pad.api.WmsSoApi;
import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.DeliveryOrderItemReq;
import org.jeecg.modules.pad.api.bean.req.DeliveryOrderReq;
import org.jeecg.modules.pad.api.bean.req.SoExecuteSecondPickProReq;
import org.jeecg.modules.pad.api.bean.res.DeliveryOrderInfo;
import org.jeecg.modules.pad.api.bean.res.DeliveryOrderItemInfo;
import org.jeecg.modules.pad.api.bean.res.SecondPickProInfo;
import org.jeecg.modules.pad.service.IPdaDelivery;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class PdaDeliveryImpl implements IPdaDelivery {
    @Resource
    private WmsSoApi wmsSoApi;
    @Override
    public WmsRes<List<DeliveryOrderInfo>> listSecondPickDelivery() {
        return wmsSoApi.listSecondPickDelivery();
    }

    @Override
    public WmsPageRes<DeliveryOrderItemInfo> listSecondPickDeliveryItem(DeliveryOrderReq orderInfo, Integer pageNo, Integer pageSize) {
        return wmsSoApi.listSecondPickDeliveryItem(orderInfo, pageNo, pageSize);
    }

    @Override
    public WmsRes<SecondPickProInfo> listSecondPickPro(DeliveryOrderItemReq req) {
        return wmsSoApi.listSecondPickPro(req);
    }

    @Override
    public WmsRes<?> executeSecondPickPro(SoExecuteSecondPickProReq req) {
        return wmsSoApi.executeSecondPickPro(req);
    }
}
