package org.jeecg.modules.pad.service.impl;

import org.jeecg.modules.pad.api.WmsCheckApi;
import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CheckCallReq;
import org.jeecg.modules.pad.api.bean.req.CheckSkuInfoReq;
import org.jeecg.modules.pad.api.bean.req.CheckToDoReq;
import org.jeecg.modules.pad.api.bean.req.CheckUpdateSkuReq;
import org.jeecg.modules.pad.api.bean.res.CheckInfo;
import org.jeecg.modules.pad.api.bean.res.CheckOrderInfo;
import org.jeecg.modules.pad.api.bean.res.CheckSkuInfo;
import org.jeecg.modules.pad.service.IPdaCheckInventory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class PdaCheckInventoryImpl implements IPdaCheckInventory {
    @Resource
    private WmsCheckApi wmsCheckApi;
    @Override
    public WmsPageRes<CheckOrderInfo> getCheckOrders(CheckToDoReq req) {
        return wmsCheckApi.todoList(req);
    }

    @Override
    public WmsRes<CheckInfo> getCheckOrderInfo(int id) {
        return wmsCheckApi.getInfo(id);
    }

    @Override
    public WmsRes<List<CheckSkuInfo>> getBoxInfo(CheckSkuInfoReq req) {
        return wmsCheckApi.getSkuInfoBuContainerCode(req);
    }

    @Override
    public WmsRes<?> callBox(CheckCallReq req) {
        return wmsCheckApi.callOut(req);
    }

    @Override
    public WmsRes<?> callBox(List<CheckCallReq> req) {
        return wmsCheckApi.callOutMulti(req);
    }

    @Override
    public WmsRes<?> updateMaterialInfo(CheckUpdateSkuReq req) {
        return wmsCheckApi.updateSku(req);
    }

    @Override
    public WmsRes<?> returnBox(CheckCallReq req) {
        return wmsCheckApi.callBack(req);
    }

    @Override
    public WmsRes<?> finishCheckOrder(String orderNo) {
        return wmsCheckApi.done(orderNo);
    }
}
