package org.jeecg.modules.pad.controller;

import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.SoReturnRestPickReq;
import org.jeecg.modules.pad.api.bean.req.TransferReq;
import org.jeecg.modules.pad.api.bean.res.SoListRestPick;
import org.jeecg.modules.pad.service.IPdaTransferPallets;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

@Api(tags="托盘转运")
@RestController
@RequestMapping("/pda/transferPallets")
@Slf4j
@AllArgsConstructor
public class PdaTransferPalletsController {
    private final IPdaTransferPallets pdaTransferPallets;
    @GetMapping("/getMaterials")
    public Result<SoListRestPick> getMaterials(@RequestParam(name="palletCode", defaultValue="") String palletCode) {
        if (StrUtil.isBlank(palletCode)){
            return Result.error("参数异常");
        }
        WmsRes<SoListRestPick> result = pdaTransferPallets.getExcessMaterials(palletCode);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/transfer")
    public Result<?> transfer(@RequestBody TransferReq req) {
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<?> result = pdaTransferPallets.transferPallets(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }
}
