package org.jeecg.modules.pad.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.TaskReq;
import org.jeecg.modules.pad.api.bean.req.TaskUpdateReq;
import org.jeecg.modules.pad.api.bean.res.SoListRestPick;
import org.jeecg.modules.pad.api.bean.res.TaskInfo;
import org.jeecg.modules.pad.service.IPdaTaskSearch;
import org.springframework.web.bind.annotation.*;

@Api(tags = "任务查询/更新")
@RestController
@RequestMapping("/pda/taskSearch")
@Slf4j
@AllArgsConstructor
public class PdaTaskSearchController {
    private final IPdaTaskSearch pdaTaskSearch;

    @GetMapping("/getTaskInfo")
    public Result<IPage<TaskInfo>> getTaskInfo(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                               @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                               @RequestParam(name = "code", defaultValue = "") String code,
                                               @RequestParam(name = "status", defaultValue = "") String status,
                                               @RequestParam(name = "ware", defaultValue = "") String ware) {
        TaskReq req = new TaskReq();
        req.setPageNum(pageNo.toString());
        req.setPageSize(pageSize.toString());
        req.setTaskStatus(status);
        req.setWareCode(ware);
        req.setPalletCode(code);
        req.setTaskId(0L);

        WmsPageRes<TaskInfo> result = pdaTaskSearch.getTaskInfo(req);
        if (result == null) {
            return Result.error("请求异常");
        }

        if (result.getCode() != 200) {
            return Result.error(result.getMsg());
        }
        IPage<TaskInfo> page = new Page<>(pageNo, pageSize, result.getTotal());
        page.setRecords(result.getRows());
        return Result.OK(page);
    }

    @PostMapping("/manualTaskUpdate")
    public Result<SoListRestPick> manualTaskUpdate(@RequestBody TaskUpdateReq req) {
        if (StrUtil.isBlank(req.getTaskId()) || StrUtil.isBlank(req.getTaskStatus())) {
            return Result.error("参数异常");
        }
        WmsRes<?> result = pdaTaskSearch.manualTaskUpdate(req);
        if (result == null) {
            return Result.error("请求异常");
        }

        if (result.getCode() != 200) {
            return Result.error(result.getMsg());
        }

        return Result.OK();
    }
}
