package org.jeecg.modules.pad.controller;

import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.StationReleaseReq;
import org.jeecg.modules.pad.api.bean.res.StationInfo;
import org.jeecg.modules.pad.service.IPdaStation;
import org.springframework.web.bind.annotation.*;

@Api(tags="站位管理")
@RestController
@RequestMapping("/pda/station")
@AllArgsConstructor
public class PdaStationController {
    private final IPdaStation pdaStation;

    @GetMapping("/getStationInfo")
    public Result<StationInfo> getStationInfo(@RequestParam(name="stationCode", defaultValue="") String stationCode) {
        if (StrUtil.isBlank(stationCode)){
            return Result.error("参数异常");
        }
        WmsRes<StationInfo> result = pdaStation.getStationInfo(stationCode);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/release")
    public Result<?> transfer(@RequestBody StationReleaseReq req) {
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<?> result = pdaStation.release(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }
}
