package org.jeecg.modules.pad.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.pad.api.bean.base.WmsPageRes;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.*;
import org.jeecg.modules.pad.api.bean.res.*;
import org.jeecg.modules.pad.service.IPdaSorting;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

@Api(tags="分拣")
@RestController
@RequestMapping("/pda/sorting")
@Slf4j
@AllArgsConstructor
public class PdaSortingController {
    private final IPdaSorting pdaSorting;

    @PostMapping("/getOutMaterials")
    public Result<SoListGoods> getOutMaterials(@RequestBody SoListGoodsReq req) {
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<SoListGoods> result = pdaSorting.getOutMaterials(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @GetMapping("/getOutMaterialsByPage")
    public Result<IPage<SoListGoods.GoodsInfo>> getOutMaterialsByPage(SoListGoodsReq req,
                                                            @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                                                            @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        if (req == null){
            return Result.error("参数异常");
        }

        WmsPageRes<SoListGoods.GoodsInfo> result = pdaSorting.getOutMaterialsPage(req, pageNo, pageSize);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        IPage<SoListGoods.GoodsInfo> page = new Page<>(pageNo, pageSize, result.getTotal());
        page.setRecords(result.getRows());
        return Result.OK(page);
    }

    @PostMapping("/getPickMaterials")
    public Result<SoFirstPickInfo> getPickMaterials(@RequestBody SoListFirstPickReq req) {
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<SoFirstPickInfo> result = pdaSorting.getPickMaterials(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/stockOut")
    public Result<?> stockOut(@RequestBody SoPullFirstPickReq req) {
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<?> result = pdaSorting.stockOut(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @GetMapping("/getPalletInfo")
    public Result<SoFirstPickByCode> getPalletInfo(@RequestParam(name="palletCode", defaultValue="") String palletCode) {
        if (StrUtil.isBlank(palletCode)){
            return Result.error("参数异常");
        }
        WmsRes<SoFirstPickByCode> result = pdaSorting.getPalletInfo(palletCode);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/pick")
    public Result<?> pick(@RequestBody SoExecuteFirstPickReq req) {
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<?> result = pdaSorting.pick(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @GetMapping("/getExcessMaterials")
    public Result<SoListRestPick> getExcessMaterials(@RequestParam(name="palletCode", defaultValue="") String palletCode) {
        if (StrUtil.isBlank(palletCode)){
            return Result.error("参数异常");
        }
        WmsRes<SoListRestPick> result = pdaSorting.getExcessMaterials(palletCode);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/returnMaterials")
    public Result<?> returnMaterials(@RequestBody SoReturnRestPickReq req) {
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<?> result = pdaSorting.returnMaterials(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @GetMapping("/getGoodsTypeList")
    public Result<GoodsTypeInfo> getGoodsTypeList() {
        WmsRes<GoodsTypeInfo> result = pdaSorting.getGoodsTypeList();
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @GetMapping("/getResponsibleUserList")
    public Result<ResponsibleUserInfo> getResponsibleUserList() {
        WmsRes<ResponsibleUserInfo> result = pdaSorting.getResponsibleUserList();
        if (result == null){
            return Result.error("请求异常");
        }
        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }
        return Result.OK(result.getData());
    }

    @PostMapping("/pickScan")
    public Result<?> pickScan(@RequestBody SoExecuteFirstPickProReq req) {
        if (req == null){
            return Result.error("参数异常");
        }
        WmsRes<SoBoxInfo> result = pdaSorting.executeFirstPickPro(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/pickCommit")
    public Result<?> pickCommit(@RequestBody SoExecuteFirstPickProReq req) {
        if (req == null){
            return Result.error("参数异常");
        }

        WmsRes<?> result = pdaSorting.finishFirstPick(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }
}
