package org.jeecg.modules.pad.controller;

import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.PalletBindReq;
import org.jeecg.modules.pad.api.bean.req.QrcodeReq;
import org.jeecg.modules.pad.api.bean.res.QrcodeInfo;
import org.jeecg.modules.pad.service.IPdaMeshPallets;
import org.springframework.web.bind.annotation.*;

@Api(tags="组托")
@RestController
@RequestMapping("/pda/meshPallets")
@Slf4j
@AllArgsConstructor
public class PdaMeshPalletsController {
    private final IPdaMeshPallets pdaMeshPallets;

    @GetMapping("/parseQrCode")
    public Result<QrcodeInfo> parseQrCode(@RequestParam(name="code", defaultValue="") String code) {
        if (StrUtil.isBlank(code)){
            return Result.error("参数异常");
        }
        QrcodeReq req = new QrcodeReq();
        req.setCode(code);
        WmsRes<QrcodeInfo> result = pdaMeshPallets.parseQrCode(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }

    @PostMapping("/mesh")
    public Result<?> mesh(@RequestBody PalletBindReq req) {
        if (req == null){
            return Result.error("参数异常");
        }

        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        if (sysUser == null){
            return Result.error("用户未登录");
        }
        req.setUser(sysUser.getUsername());

        WmsRes<?> result = pdaMeshPallets.bindPallet(req);
        if (result == null){
            return Result.error("请求异常");
        }

        if (result.getCode() != 200){
            return Result.error(result.getMsg());
        }

        return Result.OK(result.getData());
    }
}
